/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.storage.psql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anotheria.moskito.core.predefined.ActionStats;
import net.anotheria.moskito.core.predefined.FilterStats;
import net.anotheria.moskito.core.predefined.MemoryStats;
import net.anotheria.moskito.core.predefined.OSStats;
import net.anotheria.moskito.core.predefined.RuntimeStats;
import net.anotheria.moskito.core.predefined.ServiceStats;
import net.anotheria.moskito.core.predefined.ServletStats;
import net.anotheria.moskito.core.predefined.ThreadCountStats;
import net.anotheria.moskito.core.predefined.ThreadStateStats;
import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.moskito.central.storage.helpers.IncludeExcludeWildcardList;
import org.moskito.central.storage.psql.PSQLStorageConfigIncludeExcludeEntry;
import org.moskito.central.storage.psql.PSQLStorageConfigProducerNameToEntityClassMappingEntry;
import org.moskito.central.storage.psql.entities.FilterStatEntity;
import org.moskito.central.storage.psql.entities.HttpSessionStatisticsEntity;
import org.moskito.central.storage.psql.entities.MemoryStatEntity;
import org.moskito.central.storage.psql.entities.OSStatEntity;
import org.moskito.central.storage.psql.entities.RuntimeStatEntity;
import org.moskito.central.storage.psql.entities.ServiceStatsEntity;
import org.moskito.central.storage.psql.entities.StatisticsEntity;
import org.moskito.central.storage.psql.entities.ThreadCountStatEntity;
import org.moskito.central.storage.psql.entities.ThreadStatesStatEntity;

@ConfigureMe
public class PSQLStorageConfig {
    @Configure
    private String driver;
    @Configure
    private String url;
    @Configure
    private String userName;
    @Configure
    private String password;
    @Configure
    private String hibernateDialect;
    @Configure
    private PSQLStorageConfigProducerNameToEntityClassMappingEntry[] mappings;
    private List<PSQLStorageConfigProducerNameToEntityClassMappingIncludeExcludeElement> elements;
    @Configure
    private PSQLStorageConfigIncludeExcludeEntry[] includeExclude;
    private List<PSQLStorageConfigIncludeExcludeElement> includeExcludeElements;
    private static final Map<String, Class<? extends StatisticsEntity>> predefined = new HashMap<String, Class<? extends StatisticsEntity>>();

    static {
        predefined.put(ActionStats.class.getName(), ServiceStatsEntity.class);
        predefined.put(ServiceStats.class.getName(), ServiceStatsEntity.class);
        predefined.put(ServletStats.class.getName(), ServiceStatsEntity.class);
        predefined.put(FilterStats.class.getName(), FilterStatEntity.class);
        predefined.put(MemoryStats.class.getName(), MemoryStatEntity.class);
        predefined.put(OSStats.class.getName(), OSStatEntity.class);
        predefined.put(RuntimeStats.class.getName(), RuntimeStatEntity.class);
        predefined.put(ThreadCountStats.class.getName(), ThreadCountStatEntity.class);
        predefined.put(ThreadStateStats.class.getName(), ThreadStatesStatEntity.class);
        predefined.put("net.anotheria.moskito.sql.stats.QueryStringStats", ServiceStatsEntity.class);
        predefined.put("net.anotheria.moskito.sql.stats.QueryStats", FilterStatEntity.class);
        predefined.put("net.anotheria.moskito.web.session.SessionCountStats", HttpSessionStatisticsEntity.class);
    }

    public PSQLStorageConfigProducerNameToEntityClassMappingEntry[] getMappings() {
        return this.mappings;
    }

    public void setMappings(PSQLStorageConfigProducerNameToEntityClassMappingEntry[] mappings) {
        this.mappings = mappings;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getHibernateDialect() {
        return this.hibernateDialect;
    }

    public void setHibernateDialect(String hibernateDialect) {
        this.hibernateDialect = hibernateDialect;
    }

    public PSQLStorageConfigIncludeExcludeEntry[] getIncludeExclude() {
        return this.includeExclude;
    }

    public void setIncludeExclude(PSQLStorageConfigIncludeExcludeEntry[] includeExclude) {
        this.includeExclude = includeExclude;
    }

    public String toString() {
        return "PSQLStorageConfig [driver=" + this.driver + ", url=" + this.url + ", userName=" + this.userName + ", password=" + this.password + ", hibernateDialect=" + this.hibernateDialect + ", mappings=" + Arrays.toString(this.mappings) + ", elements=" + this.elements + ", includeExclude=" + Arrays.toString(this.includeExclude) + ", includeExcludeElements=" + this.includeExcludeElements + "]";
    }

    @AfterConfiguration
    public void afterConfig() {
        int n;
        ArrayList<PSQLStorageConfigProducerNameToEntityClassMappingIncludeExcludeElement> newElements = new ArrayList<PSQLStorageConfigProducerNameToEntityClassMappingIncludeExcludeElement>();
        if (this.mappings != null) {
            PSQLStorageConfigProducerNameToEntityClassMappingEntry[] pSQLStorageConfigProducerNameToEntityClassMappingEntryArray = this.mappings;
            n = this.mappings.length;
            int n2 = 0;
            while (n2 < n) {
                PSQLStorageConfigProducerNameToEntityClassMappingEntry entry = pSQLStorageConfigProducerNameToEntityClassMappingEntryArray[n2];
                PSQLStorageConfigProducerNameToEntityClassMappingIncludeExcludeElement element = new PSQLStorageConfigProducerNameToEntityClassMappingIncludeExcludeElement(entry);
                newElements.add(element);
                ++n2;
            }
            this.elements = newElements;
        }
        ArrayList<PSQLStorageConfigIncludeExcludeElement> newIncludeExcludeElements = new ArrayList<PSQLStorageConfigIncludeExcludeElement>();
        if (this.includeExclude != null) {
            PSQLStorageConfigIncludeExcludeEntry[] pSQLStorageConfigIncludeExcludeEntryArray = this.includeExclude;
            int n3 = this.includeExclude.length;
            n = 0;
            while (n < n3) {
                PSQLStorageConfigIncludeExcludeEntry entry = pSQLStorageConfigIncludeExcludeEntryArray[n];
                PSQLStorageConfigIncludeExcludeElement element = new PSQLStorageConfigIncludeExcludeElement(entry);
                newIncludeExcludeElements.add(element);
                ++n;
            }
            this.includeExcludeElements = newIncludeExcludeElements;
        }
    }

    public Class<? extends StatisticsEntity> getStatEntityClassName(String statClassName, String producerId) {
        Class<StatisticsEntity> entityClass = predefined.get(statClassName);
        if (entityClass != null) {
            return entityClass;
        }
        List<PSQLStorageConfigProducerNameToEntityClassMappingIncludeExcludeElement> listCopy = this.elements;
        if (listCopy == null) {
            return null;
        }
        for (PSQLStorageConfigProducerNameToEntityClassMappingIncludeExcludeElement element : listCopy) {
            if (!element.include(producerId)) continue;
            try {
                entityClass = Class.forName(element.getStatEntityClassName());
                return entityClass;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return null;
    }

    public boolean include(String producerId, String interval) {
        if (this.includeExcludeElements == null) {
            return false;
        }
        for (PSQLStorageConfigIncludeExcludeElement elem : this.includeExcludeElements) {
            if (!elem.include(producerId, interval)) continue;
            return true;
        }
        return false;
    }

    private static class PSQLStorageConfigIncludeExcludeElement {
        private IncludeExcludeWildcardList producers;
        private IncludeExcludeWildcardList intervals;

        public PSQLStorageConfigIncludeExcludeElement(PSQLStorageConfigIncludeExcludeEntry entry) {
            this.producers = new IncludeExcludeWildcardList(entry.getIncludedProducers(), entry.getExcludedProducers());
            this.intervals = new IncludeExcludeWildcardList(entry.getIncludedIntervals(), entry.getExcludedIntervals());
        }

        public boolean include(String producer, String interval) {
            return this.producers.include(producer) && this.intervals.include(interval);
        }

        public String toString() {
            return "PSQLStorageConfigIncludeExcludeElement [producers=" + this.producers + ", intervals=" + this.intervals + "]";
        }
    }

    private static class PSQLStorageConfigProducerNameToEntityClassMappingIncludeExcludeElement {
        private IncludeExcludeWildcardList producers;
        private String statEntityClassName;

        public PSQLStorageConfigProducerNameToEntityClassMappingIncludeExcludeElement(PSQLStorageConfigProducerNameToEntityClassMappingEntry entry) {
            this.producers = new IncludeExcludeWildcardList(entry.getProducerName(), "");
            this.statEntityClassName = entry.getStatEntityClass();
        }

        public boolean include(String producer) {
            return this.producers.include(producer);
        }

        public String toString() {
            return "PSQLStorageConfigElement [producers=" + this.producers + "]";
        }

        public String getStatEntityClassName() {
            return this.statEntityClassName;
        }
    }
}

