/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.storage.rabbitmq;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import org.configureme.ConfigurationManager;
import org.moskito.central.Snapshot;
import org.moskito.central.storage.Storage;
import org.moskito.central.storage.helpers.SnapshotWithStatsNumbers;
import org.moskito.central.storage.rabbitmq.RabbitStorageConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitStorage
implements Storage {
    private static Logger log = LoggerFactory.getLogger(RabbitStorage.class);
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private RabbitStorageConfig config;
    private Channel channel;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    public void configure(String configurationName) {
        this.config = new RabbitStorageConfig();
        if (configurationName == null) {
            return;
        }
        try {
            ConfigurationManager.INSTANCE.configureAs((Object)this.config, configurationName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn("Couldn't configure RabbitStorage with " + configurationName + " , working with default values");
        }
    }

    public void processSnapshot(Snapshot target) {
        try {
            try {
                this.initRabbitChannel();
                RabbitPublisher task = new RabbitPublisher(target);
                this.executorService.submit(task).get();
            }
            catch (InterruptedException e) {
                log.warn("RabbitStorage.processSnapshot(): rabbit publisher interrupted", (Throwable)e);
                this.closeChannel();
            }
            catch (ExecutionException e) {
                log.error("RabbitStorage.processSnapshot(): error while rabbitmq message processing", (Throwable)e);
                this.closeChannel();
            }
        }
        finally {
            this.closeChannel();
        }
    }

    private void closeChannel() {
        if (this.channel != null || this.channel.isOpen()) {
            try {
                this.channel.close();
                this.channel = null;
            }
            catch (IOException e) {
                log.warn("couldn't close rabbitMQ channel", (Throwable)e);
            }
            catch (TimeoutException e) {
                log.warn("couldn't close rabbitMQ channel with timeout", (Throwable)e);
            }
        }
    }

    private synchronized void initRabbitChannel() {
        if (this.channel == null || !this.channel.isOpen()) {
            ConnectionFactory factory = new ConnectionFactory();
            factory.setHost(this.config.getHost());
            factory.setPort(this.config.getPort());
            factory.setUsername(this.config.getUser());
            factory.setPassword(this.config.getPassword());
            try {
                this.channel = factory.newConnection().createChannel();
                this.channel.queueDeclarePassive(this.config.getQueueName());
            }
            catch (IOException e) {
                log.error("RabbitPublisher():Error while channel creation", (Throwable)e);
            }
            catch (TimeoutException e) {
                log.error("RabbitPublisher(): Timeout expired", (Throwable)e);
            }
        }
    }

    private class RabbitPublisher
    implements Runnable {
        private final SnapshotWithStatsNumbers target;

        public RabbitPublisher(Snapshot target) {
            this.target = new SnapshotWithStatsNumbers(target);
        }

        @Override
        public void run() {
            String message = "";
            try {
                message = RabbitStorage.this.gson.toJson((Object)this.target);
                AMQP.BasicProperties.Builder basicProperties = new AMQP.BasicProperties.Builder();
                RabbitStorage.this.channel.basicPublish("", RabbitStorage.this.config.getQueueName(), basicProperties.build(), message.getBytes("UTF-8"));
            }
            catch (IOException e) {
                log.error("Error while " + message + "proceeding", (Throwable)e);
            }
        }
    }
}

