/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.storage.tsdb;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.anotheria.util.StringUtils;
import org.moskito.central.Snapshot;
import org.moskito.central.storage.tsdb.OpenTSDBMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTSDBHelper {
    private static final String TAG_INTERVAL = "intervalName";
    private static final String TAG_HOST = "hostName";
    private static final String TAG_COMPONENT = "componentName";
    private static Logger log = LoggerFactory.getLogger(OpenTSDBHelper.class);
    private ConcurrentMap<String, List<String>> cachedValueNames = new ConcurrentHashMap<String, List<String>>();
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public List<OpenTSDBMetric> convert(Snapshot snapshot, String stat, Map<String, String> tags) {
        List<String> valueNames = this.getValueNames(snapshot);
        Map data = snapshot.getStatistics(stat);
        if (data == null) {
            return null;
        }
        ArrayList<OpenTSDBMetric> metrics = new ArrayList<OpenTSDBMetric>();
        long creationTimestamp = snapshot.getMetaData().getCreationTimestamp();
        NumberFormat nf = NumberFormat.getInstance();
        for (String s : valueNames) {
            Number value;
            String valueString = (String)data.get(s);
            if (StringUtils.isEmpty((String)valueString)) {
                log.info(String.format("Skipped, empty value for stat %s.%s.%s", snapshot.getMetaData().getProducerId(), stat, s));
                continue;
            }
            try {
                value = nf.parse(valueString);
            }
            catch (ParseException parseException) {
                log.info(String.format("Skipped, can't parse value %s for stat %s.%s.%s", valueString, snapshot.getMetaData().getProducerId(), stat, s));
                continue;
            }
            OpenTSDBMetric metric = new OpenTSDBMetric();
            metric.setMetric(String.format("%s.%s.%s", snapshot.getMetaData().getProducerId(), stat, s));
            metric.setValue(value);
            metric.setTimestamp(creationTimestamp);
            metric.setTags(tags);
            metrics.add(metric);
        }
        return metrics;
    }

    public Map<String, String> getTags(Snapshot snapshot) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(TAG_HOST, snapshot.getMetaData().getHostName());
        tags.put(TAG_COMPONENT, snapshot.getMetaData().getComponentName());
        tags.put(TAG_INTERVAL, snapshot.getMetaData().getIntervalName());
        return tags;
    }

    public String toJson(List<OpenTSDBMetric> metrics) {
        return this.gson.toJson(metrics);
    }

    private List<String> getValueNames(Snapshot snapshot) {
        ArrayList valueNames = (ArrayList)this.cachedValueNames.get(snapshot.getMetaData().getProducerId());
        if (valueNames != null) {
            return valueNames;
        }
        valueNames = new ArrayList();
        Set entries = snapshot.getEntrySet();
        if (entries.size() == 0) {
            List old = this.cachedValueNames.putIfAbsent(snapshot.getMetaData().getProducerId(), valueNames);
            return old == null ? valueNames : old;
        }
        Map oneStat = (Map)((Map.Entry)entries.iterator().next()).getValue();
        valueNames.addAll(oneStat.keySet());
        Collections.sort(valueNames);
        List old = this.cachedValueNames.putIfAbsent(snapshot.getMetaData().getProducerId(), valueNames);
        return old == null ? valueNames : old;
    }
}

