/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.storage.tsdb;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.configureme.ConfigurationManager;
import org.moskito.central.Snapshot;
import org.moskito.central.storage.Storage;
import org.moskito.central.storage.tsdb.OpenTSDBHelper;
import org.moskito.central.storage.tsdb.OpenTSDBMetric;
import org.moskito.central.storage.tsdb.OpenTSDBStorageConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTSDBStorage
implements Storage {
    private static Logger log = LoggerFactory.getLogger(OpenTSDBStorage.class);
    private static final int[] SUCCESS_CODES = new int[]{200, 204};
    private OpenTSDBStorageConfig config;
    private OpenTSDBHelper helper = new OpenTSDBHelper();

    public void configure(String configurationName) {
        this.config = new OpenTSDBStorageConfig();
        if (configurationName == null) {
            return;
        }
        try {
            ConfigurationManager.INSTANCE.configureAs((Object)this.config, configurationName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn("Couldn't configure OpenTSDBStorage with " + configurationName + " , working with default values");
        }
        log.info("Configured OpenTSDBStorage " + this.config + " from configuration file " + configurationName);
    }

    public void processSnapshot(Snapshot target) {
        String producerId = target.getMetaData().getProducerId();
        String interval = target.getMetaData().getIntervalName();
        Set stats = target.getKeySet();
        if (stats == null || stats.size() == 0) {
            return;
        }
        Map<String, String> tags = this.helper.getTags(target);
        ArrayList<OpenTSDBMetric> metrics = new ArrayList<OpenTSDBMetric>();
        for (String stat : stats) {
            if (!this.config.include(producerId, stat, interval)) continue;
            metrics.addAll(this.helper.convert(target, stat, tags));
        }
        if (metrics.isEmpty()) {
            return;
        }
        try {
            HttpPost httpPost = new HttpPost(this.config.getUrl());
            StringEntity entity = new StringEntity(this.helper.toJson(metrics));
            entity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)entity);
            CloseableHttpClient client = HttpClients.createDefault();
            HttpResponse response = client.execute((HttpUriRequest)httpPost);
            if (SUCCESS_CODES[0] != response.getStatusLine().getStatusCode() && SUCCESS_CODES[1] != response.getStatusLine().getStatusCode()) {
                log.error("TSDB storage: failed to process snapshot: " + response.toString());
            }
        }
        catch (Exception e) {
            log.error("TSDB storage: failed to process snapshot: " + e.getMessage());
        }
    }
}

