/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector;

import javax.annotation.Nonnull;
import org.mutabilitydetector.Reason;
import org.mutabilitydetector.internal.com.google.common.base.Objects;
import org.mutabilitydetector.locations.CodeLocation;

public final class MutableReasonDetail {
    private final String message;
    private final CodeLocation<?> location;
    private final Reason reason;
    private final int hashCode;

    private MutableReasonDetail(String message, CodeLocation<?> location, Reason reason) {
        this.message = message;
        this.location = location;
        this.reason = reason;
        this.hashCode = Objects.hashCode(message, location, reason);
    }

    public static MutableReasonDetail newMutableReasonDetail(@Nonnull String message, @Nonnull CodeLocation<?> location, @Nonnull Reason reason) {
        MutableReasonDetail.checkNotNull(message, location, reason);
        return new MutableReasonDetail(message, location, reason);
    }

    private static void checkNotNull(String message, CodeLocation<?> location, Reason reason) {
        if (message == null) {
            throw new NullPointerException("message cannot be null");
        }
        if (location == null) {
            throw new NullPointerException("location cannot be null");
        }
        if (reason == null) {
            throw new NullPointerException("reason cannot be null");
        }
    }

    public Reason reason() {
        return this.reason;
    }

    public CodeLocation<?> codeLocation() {
        return this.location;
    }

    public String message() {
        return this.message;
    }

    public String toString() {
        return String.format("%s@%s[%s, %s, %s]", this.getClass().getSimpleName(), Integer.toHexString(this.hashCode()), this.message, this.reason, this.location);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutableReasonDetail other = (MutableReasonDetail)obj;
        if (!this.location.equals(other.location)) {
            return false;
        }
        if (!this.message.equals(other.message)) {
            return false;
        }
        return this.reason.equals(other.reason);
    }
}

