/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.mutabilitydetector.AnalysisError;
import org.mutabilitydetector.AnalysisResult;
import org.mutabilitydetector.IsImmutable;
import org.mutabilitydetector.MutableReasonDetail;
import org.mutabilitydetector.asmoverride.AsmVerifierFactory;
import org.mutabilitydetector.checkers.AsmMutabilityChecker;
import org.mutabilitydetector.checkers.CheckerResult;
import org.mutabilitydetector.checkers.CheckerRunner;
import org.mutabilitydetector.checkers.CheckerRunnerFactory;
import org.mutabilitydetector.checkers.MutabilityCheckerFactory;
import org.mutabilitydetector.checkers.ResultCalculator;
import org.mutabilitydetector.checkers.info.AnalysisDatabase;
import org.mutabilitydetector.checkers.info.AnalysisInProgress;
import org.mutabilitydetector.checkers.info.MutableTypeInformation;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableList;
import org.mutabilitydetector.internal.com.google.common.collect.Iterables;
import org.mutabilitydetector.internal.com.google.common.collect.Lists;
import org.mutabilitydetector.internal.com.google.common.collect.Maps;
import org.mutabilitydetector.locations.Dotted;

public final class AllChecksRunner {
    private final MutabilityCheckerFactory factory;
    private final CheckerRunnerFactory checkerRunnerFactory;
    private final AsmVerifierFactory verifierFactory;
    private final Dotted toAnalyse;

    public AllChecksRunner(MutabilityCheckerFactory checkerFactory, CheckerRunnerFactory checkerRunnerFactory, AsmVerifierFactory verifierFactory, Dotted toAnalyse) {
        this.factory = checkerFactory;
        this.checkerRunnerFactory = checkerRunnerFactory;
        this.verifierFactory = verifierFactory;
        this.toAnalyse = toAnalyse;
    }

    public AnalysisResult runCheckers(ImmutableList<AnalysisResult> knownResultsSoFar, AnalysisDatabase database, MutableTypeInformation mutableTypeInformation, AnalysisInProgress analysisInProgress) {
        HashMap<IsImmutable, Integer> results = Maps.newHashMap();
        ArrayList<MutableReasonDetail> reasons = Lists.newArrayList();
        ArrayList<AnalysisError> errors = Lists.newArrayList();
        Iterable<AsmMutabilityChecker> checkers = this.factory.createInstances(database, this.verifierFactory, mutableTypeInformation, analysisInProgress);
        CheckerRunner checkerRunner = this.checkerRunnerFactory.createRunner();
        for (AsmMutabilityChecker checker : checkers) {
            CheckerResult checkerResult = checkerRunner.run(checker, this.toAnalyse, knownResultsSoFar);
            results.put(checkerResult.isImmutable, this.getNewCount(results, checkerResult.isImmutable));
            Iterables.addAll(reasons, checkerResult.reasons);
            Iterables.addAll(errors, checkerResult.errors);
        }
        IsImmutable isImmutable = new ResultCalculator().calculateImmutableStatus(results);
        return AnalysisResult.analysisResult(this.toAnalyse, isImmutable, reasons, errors);
    }

    private Integer getNewCount(Map<IsImmutable, Integer> results, IsImmutable result) {
        Integer oldCount = results.get((Object)result);
        if (oldCount == null) {
            oldCount = 0;
        }
        return oldCount + 1;
    }
}

