/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers;

import org.mutabilitydetector.checkers.hint.WrappingHint;
import org.mutabilitydetector.checkers.hint.WrappingHintGenerator;
import org.mutabilitydetector.checkers.info.CopyMethod;
import org.mutabilitydetector.internal.com.google.common.base.Preconditions;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableMap;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableMultimap;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableSet;
import org.mutabilitydetector.internal.org.objectweb.asm.Type;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.AbstractInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.FieldInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.LabelNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.LineNumberNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.MethodInsnNode;
import org.mutabilitydetector.locations.ClassNameConverter;
import org.mutabilitydetector.locations.Dotted;

public class CollectionTypeWrappedInUnmodifiableIdiomChecker {
    private static final ClassNameConverter CLASS_NAME_CONVERTER = new ClassNameConverter();
    private final FieldInsnNode fieldInsnNode;
    private final Type typeAssignedToField;
    private final ImmutableMultimap<String, CopyMethod> userDefinedCopyMethods;
    private final String typeSignature;

    public CollectionTypeWrappedInUnmodifiableIdiomChecker(FieldInsnNode fieldInsnNode, Type typeAssignedToField, ImmutableMultimap<String, CopyMethod> userDefinedCopyMethods) {
        this(fieldInsnNode, typeAssignedToField, userDefinedCopyMethods, null);
    }

    public CollectionTypeWrappedInUnmodifiableIdiomChecker(FieldInsnNode fieldInsnNode, Type typeAssignedToField, ImmutableMultimap<String, CopyMethod> userDefinedCopyMethods, String typeSignature) {
        Preconditions.checkArgument(fieldInsnNode.getOpcode() == 181, "Checking for unmodifiable wrap idiom requires PUTFIELD instruction");
        this.fieldInsnNode = fieldInsnNode;
        this.typeAssignedToField = typeAssignedToField;
        this.userDefinedCopyMethods = userDefinedCopyMethods;
        this.typeSignature = typeSignature;
    }

    public UnmodifiableWrapResult checkWrappedInUnmodifiable() {
        if (!Configuration.INSTANCE.CAN_BE_WRAPPED.contains(this.typeAssignedToField())) {
            return new UnmodifiableWrapResult(UnmodifiableWrapResult.UnmodifiableWrapStatus.FIELD_TYPE_CANNOT_BE_WRAPPED, WrappingHint.NO_HINT);
        }
        if (this.wrapsInUnmodifiable()) {
            MethodInsnNode wrappingMethodCall = (MethodInsnNode)this.lastMeaningfulNode(this.fieldInsnNode);
            if (this.safelyCopiesBeforeWrapping(wrappingMethodCall)) {
                return new UnmodifiableWrapResult(UnmodifiableWrapResult.UnmodifiableWrapStatus.WRAPS_AND_COPIES_SAFELY, WrappingHint.NO_HINT);
            }
            return new UnmodifiableWrapResult(UnmodifiableWrapResult.UnmodifiableWrapStatus.WRAPS_BUT_DOES_NOT_COPY, this.generateHint());
        }
        return new UnmodifiableWrapResult(UnmodifiableWrapResult.UnmodifiableWrapStatus.DOES_NOT_WRAP_USING_WHITELISTED_METHOD, this.generateHint());
    }

    private WrappingHint generateHint() {
        WrappingHintGenerator hintGenerator = new WrappingHintGenerator(Configuration.INSTANCE, this.typeSignature, this.typeAssignedToField, this.userDefinedCopyMethods);
        return hintGenerator.generate();
    }

    private String typeAssignedToField() {
        return CLASS_NAME_CONVERTER.dotted(this.typeAssignedToField.getInternalName());
    }

    private boolean wrapsInUnmodifiable() {
        AbstractInsnNode lastMeaningfulNode = this.lastMeaningfulNode(this.fieldInsnNode);
        if (!(lastMeaningfulNode instanceof MethodInsnNode)) {
            return false;
        }
        MethodInsnNode previousInvocation = (MethodInsnNode)lastMeaningfulNode;
        String methodName = previousInvocation.name;
        String onClass = previousInvocation.owner;
        return Configuration.INSTANCE.UNMODIFIABLE_METHOD_OWNER.equals(CLASS_NAME_CONVERTER.dotted(onClass)) && Configuration.INSTANCE.FIELD_TYPE_TO_UNMODIFIABLE_METHOD.get(this.typeAssignedToField()).equals(methodName);
    }

    private boolean safelyCopiesBeforeWrapping(MethodInsnNode unmodifiableMethodCall) {
        AbstractInsnNode lastMeaningfulNode = this.lastMeaningfulNode(unmodifiableMethodCall);
        if (!(lastMeaningfulNode instanceof MethodInsnNode)) {
            return false;
        }
        MethodInsnNode shouldBeCopyConstructor = (MethodInsnNode)lastMeaningfulNode;
        return this.configuratedAsImmutableCopyMethod(shouldBeCopyConstructor);
    }

    private boolean configuratedAsImmutableCopyMethod(MethodInsnNode shouldBeCopyConstructor) {
        return Configuration.INSTANCE.FIELD_TYPE_TO_COPY_METHODS.containsEntry(this.typeAssignedToField(), CopyMethod.from(shouldBeCopyConstructor)) || this.userDefinedCopyMethods.containsEntry(this.typeAssignedToField(), CopyMethod.from(shouldBeCopyConstructor));
    }

    private AbstractInsnNode lastMeaningfulNode(AbstractInsnNode node) {
        AbstractInsnNode previous = node.getPrevious();
        return previous instanceof LabelNode || previous instanceof LineNumberNode ? this.lastMeaningfulNode(previous) : previous;
    }

    public static class UnmodifiableWrapResult {
        public final UnmodifiableWrapStatus status;
        private final WrappingHint wrappingHint;

        public UnmodifiableWrapResult(UnmodifiableWrapStatus status, WrappingHint wrappingHint) {
            this.status = status;
            this.wrappingHint = wrappingHint;
        }

        public boolean canBeWrapped() {
            return this.status.canBeWrapped;
        }

        public boolean invokesWhitelistedWrapperMethod() {
            return this.status.invokesWhitelistedWrapperMethod;
        }

        public boolean safelyCopiesBeforeWrapping() {
            return this.status.safelyCopiesBeforeWrapping;
        }

        public String getWrappingHint(String fieldName) {
            return this.wrappingHint.getWrappingHint(fieldName);
        }

        public static enum UnmodifiableWrapStatus {
            FIELD_TYPE_CANNOT_BE_WRAPPED(false, false, false),
            DOES_NOT_WRAP_USING_WHITELISTED_METHOD(true, false, false),
            WRAPS_BUT_DOES_NOT_COPY(true, true, false),
            WRAPS_AND_COPIES_SAFELY(true, true, true);

            public final boolean canBeWrapped;
            public final boolean invokesWhitelistedWrapperMethod;
            public final boolean safelyCopiesBeforeWrapping;

            private UnmodifiableWrapStatus(boolean canBeWrapped, boolean isWrapped, boolean safelyCopiesBeforeWrapping) {
                this.canBeWrapped = canBeWrapped;
                this.invokesWhitelistedWrapperMethod = isWrapped;
                this.safelyCopiesBeforeWrapping = safelyCopiesBeforeWrapping;
            }
        }
    }

    public static enum Configuration {
        INSTANCE;

        public final ImmutableSet<String> CAN_BE_WRAPPED = ImmutableSet.of("java.util.Collection", "java.util.Set", "java.util.SortedSet", "java.util.List", "java.util.Map", "java.util.SortedMap", new String[]{"org.mutabilitydetector.internal.com.google.common.collect.ImmutableList"});
        public final String UNMODIFIABLE_METHOD_OWNER = "java.util.Collections";
        public final ImmutableMap<String, String> FIELD_TYPE_TO_UNMODIFIABLE_METHOD = ImmutableMap.builder().put("java.util.Collection", "unmodifiableCollection").put("java.util.Set", "unmodifiableSet").put("java.util.SortedSet", "unmodifiableSortedSet").put("java.util.List", "unmodifiableList").put("java.util.Map", "unmodifiableMap").put("java.util.SortedMap", "unmodifiableSortedMap").build();
        public final ImmutableMultimap<String, CopyMethod> FIELD_TYPE_TO_COPY_METHODS = ImmutableMultimap.builder().putAll("java.util.List", new CopyMethod(Dotted.dotted("java.util.ArrayList"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java.util.LinkedList"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java.util.Vector"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java.util.concurrent.CopyOnWriteArrayList"), "<init>", "(Ljava/util/Collection;)V", true)).putAll("java.util.Set", (CopyMethod[])new CopyMethod[]{new CopyMethod(Dotted.dotted("java.util.HashSet"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java.util.LinkedHashSet"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java.util.TreeSet"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java.util.TreeSet"), "<init>", "(Ljava/util/SortedSet;)V", true), new CopyMethod(Dotted.dotted("java.util.concurrent.ConcurrentSkipListSet"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java.util.concurrent.ConcurrentSkipListSet"), "<init>", "(Ljava/util/SortedSet;)V", true), new CopyMethod(Dotted.dotted("java.util.concurrent.CopyOnWriteArraySet"), "<init>", "(Ljava/util/Collection;)V", true)}).putAll("java.util.Map", (CopyMethod[])new CopyMethod[]{new CopyMethod(Dotted.dotted("java.util.HashMap"), "<init>", "(Ljava/util/Map;)V", true), new CopyMethod(Dotted.dotted("java.util.IdentityHashMap"), "<init>", "(Ljava/util/Map;)V", true), new CopyMethod(Dotted.dotted("java.util.TreeMap"), "<init>", "(Ljava/util/Map;)V", true), new CopyMethod(Dotted.dotted("java.util.TreeMap"), "<init>", "(Ljava/util/SortedMap;)V", true), new CopyMethod(Dotted.dotted("java.util.WeakHashMap"), "<init>", "(Ljava/util/Map;)V", true), new CopyMethod(Dotted.dotted("java.util.Hashtable"), "<init>", "(Ljava/util/Map;)V", true), new CopyMethod(Dotted.dotted("java.util.IdentityHashMap"), "<init>", "(Ljava/util/Map;)V", true), new CopyMethod(Dotted.dotted("java.util.LinkedHashMap"), "<init>", "(Ljava/util/Map;)V", true), new CopyMethod(Dotted.dotted("java.util.concurrent.ConcurrentHashMap"), "<init>", "(Ljava/util/Map;)V", true), new CopyMethod(Dotted.dotted("java.util.concurrent.ConcurrentSkipListMap"), "<init>", "(Ljava/util/Map;)V", true), new CopyMethod(Dotted.dotted("java.util.concurrent.ConcurrentSkipListMap"), "<init>", "(Ljava/util/SortedMap;)V", true)}).putAll("java.util.SortedMap", (CopyMethod[])new CopyMethod[]{new CopyMethod(Dotted.dotted("java.util.TreeMap"), "<init>", "(Ljava/util/Map;)V", true), new CopyMethod(Dotted.dotted("java.util.TreeMap"), "<init>", "(Ljava/util/SortedMap;)V", true), new CopyMethod(Dotted.dotted("java.util.concurrent.ConcurrentSkipListMap"), "<init>", "(Ljava/util/Map;)V", true), new CopyMethod(Dotted.dotted("java.util.concurrent.ConcurrentSkipListMap"), "<init>", "(Ljava/util/SortedMap;)V", true)}).putAll("java.util.SortedSet", (CopyMethod[])new CopyMethod[]{new CopyMethod(Dotted.dotted("java.util.TreeSet"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java.util.TreeSet"), "<init>", "(Ljava/util/SortedSet;)V", true), new CopyMethod(Dotted.dotted("java.util.concurrent.ConcurrentSkipListSet"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java.util.concurrent.ConcurrentSkipListSet"), "<init>", "(Ljava/util/SortedSet;)V", true)}).putAll("java.util.Collection", (CopyMethod[])new CopyMethod[]{new CopyMethod(Dotted.dotted("java/util/ArrayList"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java/util/concurrent/CopyOnWriteArrayList"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java/util/LinkedList"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java/util/Vector"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java/util/HashSet"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java/util/LinkedHashSet"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java/util/TreeSet"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java/util/TreeSet"), "<init>", "(Ljava/util/SortedSet;)V", true), new CopyMethod(Dotted.dotted("java/util/concurrent/ConcurrentSkipListSet"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java/util/concurrent/ConcurrentSkipListSet"), "<init>", "(Ljava/util/SortedSet;)V", true), new CopyMethod(Dotted.dotted("java/util/concurrent/CopyOnWriteArraySet"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java/util/concurrent/ConcurrentLinkedQueue"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java/util/concurrent/DelayQueue"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java/util/concurrent/LinkedBlockingDeque"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java/util/concurrent/LinkedBlockingQueue"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java/util/concurrent/LinkedTransferQueue"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java/util/concurrent/PriorityBlockingQueue"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java/util/concurrent/PriorityQueue"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java/util/concurrent/PriorityQueue"), "<init>", "(Ljava/util/concurrent/PriorityQueue;)V", true), new CopyMethod(Dotted.dotted("java/util/concurrent/PriorityQueue"), "<init>", "(Ljava/util/SortedSet;)V", true), new CopyMethod(Dotted.dotted("java/util/concurrent/ConcurrentLinkedDeque"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java/util/ArrayDeque"), "<init>", "(Ljava/util/Collection;)V", true), new CopyMethod(Dotted.dotted("java/util/concurrent/ArrayBlockingQueue"), "<init>", "(IZLjava/util/Collection;)V", true)}).build();
    }
}

