/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers;

import java.util.ArrayList;
import java.util.List;
import org.mutabilitydetector.MutabilityReason;
import org.mutabilitydetector.checkers.AsmMutabilityChecker;
import org.mutabilitydetector.checkers.MethodIs;
import org.mutabilitydetector.checkers.util.StackPushingOpcodes;
import org.mutabilitydetector.internal.org.objectweb.asm.MethodVisitor;
import org.mutabilitydetector.internal.org.objectweb.asm.Type;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.AbstractInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.FieldInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.MethodInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.MethodNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.VarInsnNode;
import org.mutabilitydetector.locations.CodeLocation;

public final class EscapedThisReferenceChecker
extends AsmMutabilityChecker {
    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        super.visitMethod(access, name, desc, signature, exceptions);
        return MethodIs.aConstructor(name) ? new ThisEscapingFromConstructorVistor(access, name, desc, signature, exceptions) : null;
    }

    private final class ThisEscapingFromConstructorVistor
    extends MethodNode {
        private final List<MethodInsnNode> methodCalls;
        private final List<FieldInsnNode> fieldAssignmentsInConstructor;
        private final StackPushingOpcodes stackPushingOpcodes;

        public ThisEscapingFromConstructorVistor(int access, String name, String desc, String signature, String[] exceptions) {
            super(327680, access, name, desc, signature, exceptions);
            this.methodCalls = new ArrayList<MethodInsnNode>();
            this.fieldAssignmentsInConstructor = new ArrayList<FieldInsnNode>();
            this.stackPushingOpcodes = new StackPushingOpcodes();
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String methodName, String methodDesc, boolean isInterface) {
            super.visitMethodInsn(opcode, owner, methodName, methodDesc, isInterface);
            if (MethodIs.aConstructor(methodName) && owner.equals("java/lang/Object")) {
                return;
            }
            this.methodCalls.add((MethodInsnNode)this.instructions.getLast());
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String fieldName, String fieldDesc) {
            super.visitFieldInsn(opcode, owner, fieldName, fieldDesc);
            if (opcode == 179 || opcode == 181) {
                this.fieldAssignmentsInConstructor.add((FieldInsnNode)this.instructions.getLast());
            }
        }

        @Override
        public void visitEnd() {
            super.visitEnd();
            this.checkForPassingThisReferenceAsParameter();
            this.checkForSettingFieldToThisReference();
        }

        private void checkForSettingFieldToThisReference() {
            if (this.fieldAssignmentsInConstructor.isEmpty()) {
                return;
            }
            for (FieldInsnNode fieldInstruction : this.fieldAssignmentsInConstructor) {
                this.checkFieldAssignment(fieldInstruction);
            }
        }

        private void checkFieldAssignment(FieldInsnNode assignment) {
            AbstractInsnNode previous = assignment.getPrevious();
            if (this.stackPushingOpcodes.includes(previous.getOpcode())) {
                this.checkForThisReferenceBeingPutOnStack(previous);
            }
        }

        private void checkForPassingThisReferenceAsParameter() {
            if (this.methodCalls.isEmpty()) {
                return;
            }
            for (MethodInsnNode methodInsnNode : this.methodCalls) {
                this.checkMethodCall(methodInsnNode);
            }
        }

        private void checkMethodCall(MethodInsnNode methodInsnNode) {
            AbstractInsnNode previous = methodInsnNode.getPrevious();
            Type[] argumentTypes = Type.getArgumentTypes(methodInsnNode.desc);
            int numberOfArguments = argumentTypes.length;
            for (int i = numberOfArguments - 1; i >= 0; --i) {
                if (this.instructionPushesSomethingElseOnTheStack(previous)) {
                    ++i;
                }
                this.checkForThisReferenceBeingPutOnStack(previous);
                previous = previous.getPrevious();
            }
        }

        private boolean instructionPushesSomethingElseOnTheStack(AbstractInsnNode previous) {
            switch (previous.getOpcode()) {
                case 89: 
                case 187: {
                    return true;
                }
            }
            return false;
        }

        private void checkForThisReferenceBeingPutOnStack(AbstractInsnNode previous) {
            if (previous instanceof VarInsnNode) {
                VarInsnNode varInstruction = (VarInsnNode)previous;
                if (varInstruction.var == 0) {
                    this.thisReferencesEscapes();
                }
            }
        }

        private void thisReferencesEscapes() {
            EscapedThisReferenceChecker.this.setResult("The 'this' reference is passed outwith the constructor.", CodeLocation.ClassLocation.fromInternalName(EscapedThisReferenceChecker.this.ownerClass), MutabilityReason.ESCAPED_THIS_REFERENCE);
        }
    }
}

