/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.mutabilitydetector.asmoverride.AsmVerifierFactory;
import org.mutabilitydetector.checkers.ArrayFieldMutabilityChecker;
import org.mutabilitydetector.checkers.AsmMutabilityChecker;
import org.mutabilitydetector.checkers.CanSubclassChecker;
import org.mutabilitydetector.checkers.CollectionWithMutableElementTypeToFieldChecker;
import org.mutabilitydetector.checkers.EscapedThisReferenceChecker;
import org.mutabilitydetector.checkers.InherentTypeMutabilityChecker;
import org.mutabilitydetector.checkers.MutableTypeToFieldChecker;
import org.mutabilitydetector.checkers.NonFinalFieldChecker;
import org.mutabilitydetector.checkers.OldSetterMethodChecker;
import org.mutabilitydetector.checkers.PublishedNonFinalFieldChecker;
import org.mutabilitydetector.checkers.info.AnalysisDatabase;
import org.mutabilitydetector.checkers.info.AnalysisInProgress;
import org.mutabilitydetector.checkers.info.MutableTypeInformation;
import org.mutabilitydetector.checkers.settermethod.SetterMethodChecker;
import org.mutabilitydetector.internal.com.google.common.collect.ImmutableSet;
import org.mutabilitydetector.locations.Dotted;

public final class MutabilityCheckerFactory {
    private final ReassignedFieldAnalysisChoice analysisChoice;
    private final Set<Dotted> immutableContainerClasses;

    public MutabilityCheckerFactory(ReassignedFieldAnalysisChoice analysisChoice, Set<Dotted> immutableContainerClasses) {
        this.analysisChoice = analysisChoice;
        this.immutableContainerClasses = immutableContainerClasses;
    }

    public Iterable<AsmMutabilityChecker> createInstances(AnalysisDatabase database, AsmVerifierFactory verifierFactory, MutableTypeInformation mutableTypeInformation, AnalysisInProgress analysisInProgress) {
        ArrayList<AsmMutabilityChecker> checkers = new ArrayList<AsmMutabilityChecker>();
        checkers.add(new CanSubclassChecker());
        checkers.add(new PublishedNonFinalFieldChecker());
        if (this.analysisChoice == ReassignedFieldAnalysisChoice.NAIVE_PUT_FIELD_ANALYSIS) {
            checkers.add(new NonFinalFieldChecker());
            checkers.add(OldSetterMethodChecker.newSetterMethodChecker(database.requestInformation(AnalysisDatabase.PRIVATE_METHOD_INVOCATION), verifierFactory));
        } else if (this.analysisChoice == ReassignedFieldAnalysisChoice.LAZY_INITIALISATION_ANALYSIS) {
            checkers.add(SetterMethodChecker.newInstance(database.requestInformation(AnalysisDatabase.PRIVATE_METHOD_INVOCATION)));
        } else {
            throw new IllegalStateException();
        }
        checkers.add(new MutableTypeToFieldChecker(database.requestInformation(AnalysisDatabase.TYPE_STRUCTURE), mutableTypeInformation, verifierFactory, this.immutableContainerClasses, analysisInProgress));
        checkers.add(new InherentTypeMutabilityChecker());
        checkers.add(new ArrayFieldMutabilityChecker());
        checkers.add(new EscapedThisReferenceChecker());
        checkers.add(new CollectionWithMutableElementTypeToFieldChecker(mutableTypeInformation, verifierFactory, ImmutableSet.copyOf(this.immutableContainerClasses), analysisInProgress));
        return Collections.unmodifiableCollection(checkers);
    }

    public static enum ReassignedFieldAnalysisChoice {
        NAIVE_PUT_FIELD_ANALYSIS,
        LAZY_INITIALISATION_ANALYSIS;

    }
}

