/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.info;

import java.util.HashMap;
import java.util.Map;
import org.mutabilitydetector.checkers.info.AnalysisInformation;
import org.mutabilitydetector.checkers.info.InfoKeyException;
import org.mutabilitydetector.checkers.info.InformationRetrievalRunner;
import org.mutabilitydetector.checkers.info.PrivateMethodInvocationInformation;
import org.mutabilitydetector.checkers.info.TypeStructureInformation;

public final class AnalysisDatabase {
    public static final InfoKey<PrivateMethodInvocationInformation> PRIVATE_METHOD_INVOCATION = new InfoKey(PrivateMethodInvocationInformation.class);
    public static final InfoKey<TypeStructureInformation> TYPE_STRUCTURE = new InfoKey(TypeStructureInformation.class);
    private final Map infoMap = new HashMap();
    private final InformationRetrievalRunner sessionCheckerRunner;

    private AnalysisDatabase(InformationRetrievalRunner sessionCheckerRunner) {
        this.sessionCheckerRunner = sessionCheckerRunner;
    }

    public static AnalysisDatabase newAnalysisDatabase(InformationRetrievalRunner sessionCheckerRunner) {
        return new AnalysisDatabase(sessionCheckerRunner);
    }

    public <I extends AnalysisInformation> I requestInformation(InfoKey<I> infoCategory) {
        return (I)(this.infoMap.containsKey(infoCategory) ? (AnalysisInformation)this.infoMap.get(infoCategory) : this.createInfoForCategory(infoCategory));
    }

    private <I> InfoKeyException newException(InfoKey<I> infoCategory) {
        return new InfoKeyException("Programming error in instantiating information class for " + infoCategory.classForInfo().getName());
    }

    private <I extends AnalysisInformation> I createInfoForCategory(InfoKey<I> infoCategory) {
        AnalysisInformation info = null;
        if (infoCategory == PRIVATE_METHOD_INVOCATION) {
            info = new PrivateMethodInvocationInformation(this.sessionCheckerRunner);
        } else if (infoCategory == TYPE_STRUCTURE) {
            info = new TypeStructureInformation(this.sessionCheckerRunner);
        }
        if (info == null) {
            throw this.newException(infoCategory);
        }
        this.infoMap.put(infoCategory, info);
        return (I)info;
    }

    public static final class InfoKey<C> {
        private final Class<C> clazz;

        private InfoKey(Class<C> clazz) {
            this.clazz = clazz;
        }

        Class<C> classForInfo() {
            return this.clazz;
        }
    }
}

