/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.settermethod;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.mutabilitydetector.MutabilityReason;
import org.mutabilitydetector.checkers.settermethod.AbstractSetterMethodChecker;
import org.mutabilitydetector.checkers.settermethod.Alias;
import org.mutabilitydetector.checkers.settermethod.AliasFinder;
import org.mutabilitydetector.checkers.settermethod.CandidatesInitialisersMapping;
import org.mutabilitydetector.checkers.settermethod.ControlFlowBlock;
import org.mutabilitydetector.checkers.settermethod.DefaultUnknownTypeValue;
import org.mutabilitydetector.checkers.settermethod.EnhancedClassNode;
import org.mutabilitydetector.checkers.settermethod.JumpInsn;
import org.mutabilitydetector.checkers.settermethod.Opcode;
import org.mutabilitydetector.checkers.settermethod.UnknownTypeValue;
import org.mutabilitydetector.internal.com.google.common.base.Preconditions;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.AbstractInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.FieldInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.FieldNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.IntInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.JumpInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.LdcInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.MethodInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.MethodNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.VarInsnNode;

@NotThreadSafe
final class AssignmentGuardVerifier {
    private final Map<FieldNode, Collection<UnknownTypeValue>> initialValues;
    private final Map<FieldNode, Collection<JumpInsn>> assignmentGuards;
    private final CandidatesInitialisersMapping candidatesInitialisersMapping;
    private final AbstractSetterMethodChecker setterMethodChecker;

    private AssignmentGuardVerifier(Map<FieldNode, Collection<UnknownTypeValue>> theInitialValues, Map<FieldNode, Collection<JumpInsn>> theAssignmentGuards, CandidatesInitialisersMapping theVariableInitialisersAssociation, AbstractSetterMethodChecker theSetterMethodChecker) {
        this.initialValues = new HashMap<FieldNode, Collection<UnknownTypeValue>>(theInitialValues);
        this.assignmentGuards = new HashMap<FieldNode, Collection<JumpInsn>>(theAssignmentGuards);
        this.candidatesInitialisersMapping = theVariableInitialisersAssociation;
        this.setterMethodChecker = theSetterMethodChecker;
    }

    public static AssignmentGuardVerifier newInstance(Map<FieldNode, Collection<UnknownTypeValue>> initialValues, Map<FieldNode, Collection<JumpInsn>> assignmentGuards, CandidatesInitialisersMapping variableInitialisersAssociation, AbstractSetterMethodChecker setterMethodChecker) {
        return new AssignmentGuardVerifier(Preconditions.checkNotNull(initialValues), Preconditions.checkNotNull(assignmentGuards), Preconditions.checkNotNull(variableInitialisersAssociation), Preconditions.checkNotNull(setterMethodChecker));
    }

    public void verify() {
        for (CandidatesInitialisersMapping.Entry e : this.candidatesInitialisersMapping) {
            this.verifyEachCandidateInitialisersPair(e);
        }
    }

    private void verifyEachCandidateInitialisersPair(CandidatesInitialisersMapping.Entry e) {
        if (this.hasAssignmentGuardFor(e.getCandidate())) {
            this.verifyEachInitialisingMethodForCandidate(e.getCandidate(), e.getInitialisers());
        } else {
            this.setFieldCanBeReassignedResultBecauseOfMissingAssignmentGuards(e.getCandidate());
        }
    }

    private boolean hasAssignmentGuardFor(FieldNode candidate) {
        return this.assignmentGuards.containsKey(candidate);
    }

    private void verifyEachInitialisingMethodForCandidate(FieldNode candidate, CandidatesInitialisersMapping.Initialisers initialisers) {
        for (MethodNode initialisingMethod : initialisers.getMethods()) {
            this.verifyEachAssignmentGuardWithinInitialisingMethod(candidate, initialisingMethod);
        }
    }

    private void verifyEachAssignmentGuardWithinInitialisingMethod(FieldNode candidate, MethodNode method) {
        EnhancedClassNode enhancedClassNode = this.setterMethodChecker.getEnhancedClassNode();
        List<ControlFlowBlock> controlFlowBlocks = enhancedClassNode.getControlFlowBlocksForMethod(method);
        for (JumpInsn assignmentGuard : this.assignmentGuards.get(candidate)) {
            ControlFlowBlock block = this.getControlFlowBlockWhichCovers(controlFlowBlocks, assignmentGuard);
            if (AssignmentGuardVerifier.isOneValueJumpInstruction(assignmentGuard)) {
                this.verifyOneValueAssignmentGuard(candidate, assignmentGuard, block);
                continue;
            }
            if (!AssignmentGuardVerifier.isTwoValuesJumpInstruction(assignmentGuard)) continue;
            this.verifyTwoValuesAssignmentGuard(candidate, assignmentGuard, block);
        }
    }

    private ControlFlowBlock getControlFlowBlockWhichCovers(Collection<ControlFlowBlock> controlFlowBlocks, JumpInsn assignmentGuard) {
        for (ControlFlowBlock controlFlowBlock : controlFlowBlocks) {
            if (!controlFlowBlock.covers(assignmentGuard.getIndexWithinMethod())) continue;
            return controlFlowBlock;
        }
        return null;
    }

    private static boolean isOneValueJumpInstruction(JumpInsn jumpInstruction) {
        switch (AssignmentGuardVerifier.getOpcode(jumpInstruction)) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                return true;
            }
        }
        return false;
    }

    private void setFieldCanBeReassignedResultBecauseOfMissingAssignmentGuards(FieldNode candidate) {
        String msgTemplate = "Lazy initialisation requires at least one assignment guard for field [%s]";
        String msg = String.format("Lazy initialisation requires at least one assignment guard for field [%s]", candidate.name);
        this.setterMethodChecker.setResultForClass(msg, MutabilityReason.FIELD_CAN_BE_REASSIGNED);
    }

    private void verifyOneValueAssignmentGuard(FieldNode candidate, JumpInsn assignmentGuard, ControlFlowBlock block) {
        if (AssignmentGuardVerifier.checksAgainstZero(assignmentGuard)) {
            this.verifyZeroCheckAssignmentGuard(candidate, assignmentGuard, block);
        } else if (AssignmentGuardVerifier.checksAgainstNonNull(assignmentGuard)) {
            this.verifyNonNullCheckAssignmentGuard(candidate, assignmentGuard, block);
        }
    }

    private static boolean checksAgainstZero(JumpInsn jumpInstruction) {
        switch (AssignmentGuardVerifier.getOpcode(jumpInstruction)) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                return true;
            }
        }
        return false;
    }

    private void verifyZeroCheckAssignmentGuard(FieldNode candidate, JumpInsn assignmentGuard, ControlFlowBlock controlFlowBlock) {
        ZeroCheckAssignmentGuardVerifier v = new ZeroCheckAssignmentGuardVerifier(candidate, assignmentGuard, controlFlowBlock);
        v.verify();
    }

    private static boolean checksAgainstNonNull(JumpInsn jumpInstruction) {
        return 199 == AssignmentGuardVerifier.getOpcode(jumpInstruction);
    }

    private static boolean isGetInstructionForVariable(AbstractInsnNode insn, FieldNode candidate) {
        boolean result = false;
        if (180 == insn.getOpcode() || 178 == insn.getOpcode()) {
            FieldInsnNode getfield = (FieldInsnNode)insn;
            result = candidate.name.equals(getfield.name);
        }
        return result;
    }

    private static boolean isLoadInstructionForAlias(FieldNode candidate, ControlFlowBlock blockWithAssignmentGuard, AbstractInsnNode insn) {
        AliasFinder f = AliasFinder.newInstance(candidate.name, blockWithAssignmentGuard);
        Alias alias = (Alias)f.find();
        return alias.doesExist && AssignmentGuardVerifier.isLoadInstructionForAlias(insn, alias);
    }

    private static boolean isLoadInstructionForAlias(AbstractInsnNode insn, Alias alias) {
        boolean result = false;
        if (2 == insn.getType()) {
            VarInsnNode loadInstruction = (VarInsnNode)insn;
            result = loadInstruction.var == alias.localVariable;
        }
        return result;
    }

    private static boolean isComparisonInsn(AbstractInsnNode abstractInsnNode) {
        switch (abstractInsnNode.getOpcode()) {
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                return true;
            }
        }
        return false;
    }

    private void verifyGetInstructionForVariable(int indexOfPreComparisonInsn, ControlFlowBlock block, FieldNode candidate) {
        int indexOfGetInstruction = indexOfPreComparisonInsn - 2;
        this.verifyComparativeValueOf(block.getBlockInstructionForIndex(indexOfGetInstruction), candidate);
    }

    private void verifyComparativeValueOf(AbstractInsnNode insn, FieldNode candidate) {
        UnknownTypeValue comparativeValue = AssignmentGuardVerifier.getComparativeValue(insn);
        if (this.isNotPossibleInitialValueOfCandidate(comparativeValue, candidate)) {
            String msgTemplate = "Assignment for field [%s] guard does not check against a possible initial value";
            String msg = String.format("Assignment for field [%s] guard does not check against a possible initial value", candidate.name);
            this.setterMethodChecker.setResultForClass(msg, MutabilityReason.FIELD_CAN_BE_REASSIGNED);
        }
    }

    private static UnknownTypeValue getComparativeValue(AbstractInsnNode insn) {
        UnknownTypeValue result = null;
        if (0 == insn.getType()) {
            Opcode opcode = Opcode.forInt(insn.getOpcode());
            result = opcode.stackValue();
        } else if (9 == insn.getType()) {
            LdcInsnNode ldcInsn = (LdcInsnNode)insn;
            result = DefaultUnknownTypeValue.getInstance(ldcInsn.cst);
        } else if (1 == insn.getType()) {
            IntInsnNode intInsnNode = (IntInsnNode)insn;
            result = DefaultUnknownTypeValue.getInstance(intInsnNode.operand);
        }
        return result;
    }

    private boolean isNotPossibleInitialValueOfCandidate(UnknownTypeValue comparativeValue, FieldNode candidate) {
        Collection<UnknownTypeValue> possibleInitialValuesOfCandidate = this.initialValues.get(candidate);
        boolean result = null != possibleInitialValuesOfCandidate ? !possibleInitialValuesOfCandidate.contains(comparativeValue) : true;
        return result;
    }

    private void verifyLoadInstructionForAlias(int indexOfLoadInstruction, ControlFlowBlock block, FieldNode candidate) {
        int indexOfLoadInsnPredecessor = indexOfLoadInstruction - 1;
        this.verifyComparativeValueOf(block.getBlockInstructionForIndex(indexOfLoadInsnPredecessor), candidate);
    }

    private static boolean checksAgainstOtherObject(JumpInsn assignmentGuard, ControlFlowBlock block, FieldNode candidate) {
        boolean result;
        int indexWithinBlock = assignmentGuard.getIndexWithinBlock();
        AbstractInsnNode possibleEqualsInsn = block.getBlockInstructionForIndex(indexWithinBlock - 1);
        if (AssignmentGuardVerifier.isEqualsInstruction(possibleEqualsInsn)) {
            AbstractInsnNode possibleGetInstructionForVariable = block.getBlockInstructionForIndex(indexWithinBlock - 3);
            result = AssignmentGuardVerifier.isGetInstructionForVariable(possibleGetInstructionForVariable, candidate);
        } else {
            result = false;
        }
        return result;
    }

    private static boolean isEqualsInstruction(AbstractInsnNode insn) {
        boolean result;
        if (5 == insn.getType()) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)insn;
            result = methodInsnNode.name.equals("equals");
        } else {
            result = false;
        }
        return result;
    }

    private static boolean isOtherObjectNotAnInitialValue(JumpInsn assignmentGuard, ControlFlowBlock block) {
        int indexWithinBlock = assignmentGuard.getIndexWithinBlock();
        AbstractInsnNode predecessorInsn = block.getBlockInstructionForIndex(indexWithinBlock - 2);
        boolean result = 1 == predecessorInsn.getOpcode();
        return result;
    }

    private void verifyNonNullCheckAssignmentGuard(FieldNode candidate, JumpInsn assignmentGuard, ControlFlowBlock controlFlowBlock) {
        NonNullCheckAssignmentGuardVerifier v = new NonNullCheckAssignmentGuardVerifier(candidate, controlFlowBlock, assignmentGuard);
        v.verify();
    }

    private static boolean isTwoValuesJumpInstruction(JumpInsn assignmentGuard) {
        switch (AssignmentGuardVerifier.getOpcode(assignmentGuard)) {
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                return true;
            }
        }
        return false;
    }

    private static int getOpcode(JumpInsn jumpInstruction) {
        JumpInsnNode jumpInsnNode = jumpInstruction.getJumpInsnNode();
        return jumpInsnNode.getOpcode();
    }

    private void verifyTwoValuesAssignmentGuard(FieldNode candidate, JumpInsn assignmentGuard, ControlFlowBlock block) {
        int indexOfPredecessor = assignmentGuard.getIndexWithinBlock() - 1;
        AbstractInsnNode predecessor = block.getBlockInstructionForIndex(indexOfPredecessor);
        if (AssignmentGuardVerifier.isGetInstructionForVariable(predecessor, candidate)) {
            this.verifyGetInstructionForVariable(indexOfPredecessor, block, candidate);
        } else if (AssignmentGuardVerifier.isLoadInstructionForAlias(candidate, block, predecessor)) {
            this.verifyLoadInstructionForAlias(indexOfPredecessor, block, candidate);
        }
    }

    private final class NonNullCheckAssignmentGuardVerifier {
        private final FieldNode candidate;
        private final ControlFlowBlock controlFlowBlock;
        private final JumpInsn assignmentGuard;

        public NonNullCheckAssignmentGuardVerifier(FieldNode theCandidate, ControlFlowBlock theControlFlowBlock, JumpInsn theAssignmentGuard) {
            this.candidate = theCandidate;
            this.controlFlowBlock = theControlFlowBlock;
            this.assignmentGuard = theAssignmentGuard;
        }

        public void verify() {
            String candidateName = this.candidate.name;
            if (AssignmentGuardVerifier.this.isNotPossibleInitialValueOfCandidate(DefaultUnknownTypeValue.getInstanceForNull(), this.candidate)) {
                String msgTemplate = "The assignment guard for lazy field [%s] should check against null. Otherwise the field gets never initialised.";
                AssignmentGuardVerifier.this.setterMethodChecker.setNonFinalFieldResult(String.format("The assignment guard for lazy field [%s] should check against null. Otherwise the field gets never initialised.", candidateName), candidateName);
            } else if (AssignmentGuardVerifier.checksAgainstOtherObject(this.assignmentGuard, this.controlFlowBlock, this.candidate)) {
                // empty if block
            }
        }
    }

    @NotThreadSafe
    private final class ZeroCheckAssignmentGuardVerifier {
        private final FieldNode candidate;
        private final JumpInsn assignmentGuard;
        private final ControlFlowBlock controlFlowBlock;

        public ZeroCheckAssignmentGuardVerifier(FieldNode theCandidate, JumpInsn theAssignmentGuard, ControlFlowBlock theControlFlowBlock) {
            this.candidate = theCandidate;
            this.assignmentGuard = theAssignmentGuard;
            this.controlFlowBlock = theControlFlowBlock;
        }

        public void verify() {
            String candidateName = this.candidate.name;
            int indexOfPredecessor = this.assignmentGuard.getIndexWithinBlock() - 1;
            AbstractInsnNode predecessor = this.controlFlowBlock.getBlockInstructionForIndex(indexOfPredecessor);
            if (AssignmentGuardVerifier.isGetInstructionForVariable(predecessor, this.candidate)) {
                String msgTemplate = "The assignment guard for lazy field [%s] is not correct.";
                String msg = String.format("The assignment guard for lazy field [%s] is not correct.", candidateName);
                if (this.isZeroOnlyPossibleInitialValueForVariable() && this.assignmentGuard.getOpcode() == Opcode.IFEQ) {
                    AssignmentGuardVerifier.this.setterMethodChecker.setFieldCanBeReassignedResult(msg);
                } else if (!this.isZeroOnlyPossibleInitialValueForVariable() && this.assignmentGuard.getOpcode() == Opcode.IFNE) {
                    AssignmentGuardVerifier.this.setterMethodChecker.setFieldCanBeReassignedResult(msg);
                }
            } else if (AssignmentGuardVerifier.isComparisonInsn(predecessor)) {
                this.verifyPredecessorOfComparisonInstruction(indexOfPredecessor - 1);
            } else if (AssignmentGuardVerifier.checksAgainstOtherObject(this.assignmentGuard, this.controlFlowBlock, this.candidate) && AssignmentGuardVerifier.isOtherObjectNotAnInitialValue(this.assignmentGuard, this.controlFlowBlock)) {
                String msgTemplate = "The compared object is not a possible initial value of lazy field [%s].";
                String msg = String.format("The compared object is not a possible initial value of lazy field [%s].", candidateName);
                AssignmentGuardVerifier.this.setterMethodChecker.setFieldCanBeReassignedResult(msg);
            }
        }

        private boolean isZeroOnlyPossibleInitialValueForVariable() {
            boolean result = true;
            Collection possibleInitialValuesForVariable = (Collection)AssignmentGuardVerifier.this.initialValues.get(this.candidate);
            Iterator i = possibleInitialValuesForVariable.iterator();
            while (result && i.hasNext()) {
                UnknownTypeValue u = (UnknownTypeValue)i.next();
                result = u.isZero();
            }
            return result;
        }

        private void verifyPredecessorOfComparisonInstruction(int indexOfInstructionToVerify) {
            AbstractInsnNode predecessorOfComparisonInsn = this.controlFlowBlock.getBlockInstructionForIndex(indexOfInstructionToVerify);
            if (AssignmentGuardVerifier.isGetInstructionForVariable(predecessorOfComparisonInsn, this.candidate)) {
                AssignmentGuardVerifier.this.verifyGetInstructionForVariable(indexOfInstructionToVerify, this.controlFlowBlock, this.candidate);
            } else if (AssignmentGuardVerifier.isLoadInstructionForAlias(this.candidate, this.controlFlowBlock, predecessorOfComparisonInsn)) {
                AssignmentGuardVerifier.this.verifyLoadInstructionForAlias(indexOfInstructionToVerify, this.controlFlowBlock, this.candidate);
            }
        }
    }
}

