/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.settermethod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.mutabilitydetector.checkers.AccessModifierQuery;
import org.mutabilitydetector.checkers.MethodIs;
import org.mutabilitydetector.internal.com.google.common.base.Preconditions;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.FieldNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.MethodNode;

@NotThreadSafe
final class CandidatesInitialisersMapping
implements Iterable<Entry> {
    private final ConcurrentMap<FieldNode, Initialisers> candidatesAndInitialisers;
    private final Map<String, Set<MethodNode>> visibleSetterMethods;

    private CandidatesInitialisersMapping() {
        this(new ConcurrentHashMap<FieldNode, Initialisers>());
    }

    private CandidatesInitialisersMapping(Map<FieldNode, Initialisers> otherVariableSetters) {
        this.candidatesAndInitialisers = new ConcurrentHashMap<FieldNode, Initialisers>(otherVariableSetters);
        this.visibleSetterMethods = new HashMap<String, Set<MethodNode>>();
    }

    public static CandidatesInitialisersMapping newInstance() {
        return new CandidatesInitialisersMapping();
    }

    public boolean addCandidate(FieldNode candidate) {
        Preconditions.checkNotNull(candidate);
        boolean result = !this.candidatesAndInitialisers.containsKey(candidate);
        this.candidatesAndInitialisers.put(candidate, DefaultInitialisers.getInstance());
        return result;
    }

    public boolean addInitialiserForCandidate(String candidateName, MethodNode initialiser) {
        Preconditions.checkArgument(!candidateName.isEmpty());
        Preconditions.checkNotNull(initialiser);
        boolean result = false;
        FieldNode candidate = this.getCandidateForName(candidateName);
        if (null != candidate) {
            result = this.addInitialiserForCandidate(candidate, initialiser);
        } else if (CandidatesInitialisersMapping.isNotAConstructor(initialiser) && CandidatesInitialisersMapping.isNotPrivate(initialiser)) {
            this.addToVisibleSetterMethods(candidateName, initialiser);
        }
        return result;
    }

    private FieldNode getCandidateForName(String candidateName) {
        for (Map.Entry entry : this.candidatesAndInitialisers.entrySet()) {
            FieldNode candidate = (FieldNode)entry.getKey();
            if (!candidate.name.equals(candidateName)) continue;
            return candidate;
        }
        return null;
    }

    private boolean addInitialiserForCandidate(FieldNode candidate, MethodNode initialiser) {
        Initialisers initialisersForCandidate = (Initialisers)this.candidatesAndInitialisers.get(candidate);
        return initialisersForCandidate.add(initialiser);
    }

    private static boolean isNotAConstructor(MethodNode methodOrConstructor) {
        String methodOrConstructorName = methodOrConstructor.name;
        return !MethodIs.aConstructor(methodOrConstructorName) && !"<clinit>".equals(methodOrConstructorName);
    }

    private static boolean isNotPrivate(MethodNode method) {
        return AccessModifierQuery.field(method.access).isNotPrivate();
    }

    private void addToVisibleSetterMethods(String candidateName, MethodNode method) {
        if (this.visibleSetterMethods.containsKey(candidateName)) {
            Set<MethodNode> setterMethods = this.visibleSetterMethods.get(candidateName);
            setterMethods.add(method);
        } else {
            HashSet<MethodNode> setterMethods = new HashSet<MethodNode>();
            setterMethods.add(method);
            this.visibleSetterMethods.put(candidateName, setterMethods);
        }
    }

    Initialisers getInitialisersFor(FieldNode candidate) {
        Preconditions.checkNotNull(candidate);
        Initialisers result = (Initialisers)this.candidatesAndInitialisers.get(candidate);
        if (null == result) {
            result = NullInitialisers.getInstance();
        }
        return result;
    }

    Collection<MethodNode> getInitialisingMethodsFor(String candidateName) {
        Preconditions.checkArgument(!candidateName.isEmpty());
        List<MethodNode> result = Collections.emptyList();
        FieldNode candidate = this.getCandidateForName(candidateName);
        if (null != candidate) {
            Initialisers settersForVariable = (Initialisers)this.candidatesAndInitialisers.get(candidate);
            result = settersForVariable.getMethods();
        }
        return result;
    }

    public Map<String, Set<MethodNode>> getAllVisibleSetterMethods() {
        return Collections.unmodifiableMap(this.visibleSetterMethods);
    }

    public FieldNode removeAndGetCandidateForInitialisingMethod(MethodNode initialisingMethod) {
        FieldNode result = null;
        Set entrySet = this.candidatesAndInitialisers.entrySet();
        Iterator iterator = entrySet.iterator();
        while (null == result && iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Initialisers initialisers = (Initialisers)entry.getValue();
            List<MethodNode> initialisingMethods = initialisers.getMethods();
            if (!initialisingMethods.contains(initialisingMethod)) continue;
            result = (FieldNode)entry.getKey();
            iterator.remove();
        }
        return result;
    }

    public Collection<FieldNode> removeAndGetCandidatesWithoutInitialisingMethod() {
        ArrayList<FieldNode> result = new ArrayList<FieldNode>();
        for (Map.Entry entry : this.candidatesAndInitialisers.entrySet()) {
            Initialisers setters = (Initialisers)entry.getValue();
            List<MethodNode> initialisingMethods = setters.getMethods();
            if (!initialisingMethods.isEmpty()) continue;
            result.add((FieldNode)entry.getKey());
        }
        for (FieldNode unassociatedVariable : result) {
            this.candidatesAndInitialisers.remove(unassociatedVariable);
        }
        return result;
    }

    @Override
    public Iterator<Entry> iterator() {
        HashSet<DefaultEntry> entrySet = new HashSet<DefaultEntry>(this.candidatesAndInitialisers.size());
        for (Map.Entry entry : this.candidatesAndInitialisers.entrySet()) {
            entrySet.add(new DefaultEntry((FieldNode)entry.getKey(), (Initialisers)entry.getValue()));
        }
        return entrySet.iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.candidatesAndInitialisers.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof CandidatesInitialisersMapping)) {
            return false;
        }
        CandidatesInitialisersMapping other = (CandidatesInitialisersMapping)o;
        return this.candidatesAndInitialisers.equals(other.candidatesAndInitialisers);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [");
        builder.append("candidatesAndInitialisers=").append(this.candidatesAndInitialisersToString());
        builder.append(", visibleSetterMethods=").append(this.visibleSetterMethods).append(']');
        return builder.toString();
    }

    private String candidatesAndInitialisersToString() {
        StringBuilder result = new StringBuilder();
        result.append('{');
        String separator = ", ";
        String sep = "";
        for (Entry entry : this) {
            FieldNode candidate = entry.getCandidate();
            result.append(sep).append(candidate.name).append(": ").append(entry.getInitialisers());
            sep = ", ";
        }
        result.append('}');
        return result.toString();
    }

    private static final class DefaultEntry
    implements Entry {
        private final FieldNode candidate;
        private final Initialisers initialisers;

        public DefaultEntry(FieldNode theCandidate, Initialisers theInitialisers) {
            String msgTemplate = "Argument '%s' must not be null!";
            this.candidate = Preconditions.checkNotNull(theCandidate, "Argument '%s' must not be null!", "theCandidate");
            this.initialisers = Preconditions.checkNotNull(theInitialisers, "Argument '%s' must not be null!", "theInitialisers");
        }

        @Override
        public FieldNode getCandidate() {
            return this.candidate;
        }

        @Override
        public Initialisers getInitialisers() {
            return this.initialisers;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.candidate.name.hashCode();
            result = 31 * result + this.candidate.desc.hashCode();
            result = 31 * result + this.initialisers.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof DefaultEntry)) {
                return false;
            }
            DefaultEntry other = (DefaultEntry)obj;
            if (!this.candidate.name.equals(other.candidate.name)) {
                return false;
            }
            if (!this.candidate.desc.equals(other.candidate.desc)) {
                return false;
            }
            return this.initialisers.equals(other.initialisers);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.getClass().getSimpleName()).append(" [");
            b.append("candidate=").append(this.candidate.name);
            b.append(", initialisers=").append(this.initialisers);
            return b.toString();
        }
    }

    public static interface Entry {
        public FieldNode getCandidate();

        public Initialisers getInitialisers();
    }

    @NotThreadSafe
    private static final class DefaultInitialisers
    implements Initialisers {
        private final List<MethodNode> constructors;
        private final List<MethodNode> methods;

        private DefaultInitialisers() {
            int initialSize = 2;
            this.constructors = new ArrayList<MethodNode>(2);
            this.methods = new ArrayList<MethodNode>(2);
        }

        public static Initialisers getInstance() {
            return new DefaultInitialisers();
        }

        @Override
        public boolean add(MethodNode setter) {
            boolean result = DefaultInitialisers.isConstructor(setter) ? this.constructors.add(setter) : this.methods.add(setter);
            return result;
        }

        private static boolean isConstructor(MethodNode setter) {
            return MethodIs.aConstructor(setter.name);
        }

        @Override
        public List<MethodNode> getConstructors() {
            return Collections.unmodifiableList(this.constructors);
        }

        @Override
        public List<MethodNode> getMethods() {
            return Collections.unmodifiableList(this.methods);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.constructors.hashCode();
            result = 31 * result + this.methods.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof DefaultInitialisers)) {
                return false;
            }
            DefaultInitialisers other = (DefaultInitialisers)obj;
            if (!this.constructors.equals(other.constructors)) {
                return false;
            }
            return this.methods.equals(other.methods);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName()).append(" [");
            builder.append("constructors=").append(DefaultInitialisers.concatenateMethodNames(this.constructors));
            builder.append(", methods=").append(DefaultInitialisers.concatenateMethodNames(this.methods)).append(']');
            return builder.toString();
        }

        private static String concatenateMethodNames(List<MethodNode> methods) {
            StringBuilder result = new StringBuilder();
            result.append('[');
            String separator = ", ";
            String sep = "";
            for (MethodNode method : methods) {
                result.append(sep).append(method.name);
                sep = ", ";
            }
            result.append(']');
            return result.toString();
        }
    }

    @Immutable
    private static final class NullInitialisers
    implements Initialisers {
        private static final NullInitialisers INSTANCE = new NullInitialisers();

        private NullInitialisers() {
        }

        public static Initialisers getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean add(MethodNode initialiser) {
            return false;
        }

        @Override
        public List<MethodNode> getConstructors() {
            return Collections.emptyList();
        }

        @Override
        public List<MethodNode> getMethods() {
            return Collections.emptyList();
        }

        public String toString() {
            return this.getClass().getSimpleName() + " []";
        }
    }

    public static interface Initialisers {
        public boolean add(MethodNode var1);

        public List<MethodNode> getConstructors();

        public List<MethodNode> getMethods();
    }
}

