/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.checkers.settermethod;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.mutabilitydetector.internal.com.google.common.base.Preconditions;
import org.mutabilitydetector.internal.org.objectweb.asm.Label;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.AbstractInsnNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.InsnList;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.LabelNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.MethodNode;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.analysis.Analyzer;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.analysis.BasicValue;
import org.mutabilitydetector.internal.org.objectweb.asm.tree.analysis.Interpreter;

@ThreadSafe
final class ControlFlowBlock
implements Comparable<ControlFlowBlock> {
    private final int blockNumber;
    private final String identifier;
    private final InsnList methodInstructions;
    private final Range rangeOfBlockInstructions;
    private final Set<ControlFlowBlock> predecessors;
    private final Set<ControlFlowBlock> successors;
    private int hashCode;
    private String stringRepresentation;

    private ControlFlowBlock(int theBlockNumber, String theIdentifier, InsnList theMethodInstructions, Range theRangeOfBlockInstructionIndices) {
        this.blockNumber = theBlockNumber;
        this.identifier = theIdentifier;
        this.methodInstructions = theMethodInstructions;
        this.rangeOfBlockInstructions = theRangeOfBlockInstructionIndices;
        this.predecessors = new HashSet<ControlFlowBlock>();
        this.successors = new HashSet<ControlFlowBlock>();
        this.hashCode = 0;
        this.stringRepresentation = null;
    }

    public static ControlFlowBlock newInstance(int blockNumber, String identifier, InsnList methodInstructions, Range rangeOfInstructionIndices) {
        Preconditions.checkArgument(!identifier.isEmpty());
        return new ControlFlowBlock(blockNumber, identifier, Preconditions.checkNotNull(methodInstructions), Preconditions.checkNotNull(rangeOfInstructionIndices));
    }

    public boolean isEmpty() {
        AbstractInsnNode soleBlockInstruction;
        List<AbstractInsnNode> blockInstructions = this.getBlockInstructions();
        boolean result = blockInstructions.isEmpty() ? true : (1 == blockInstructions.size() ? 8 == (soleBlockInstruction = blockInstructions.get(0)).getType() : false);
        return result;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public List<AbstractInsnNode> getBlockInstructions() {
        ArrayList<AbstractInsnNode> result = new ArrayList<AbstractInsnNode>();
        for (int i = this.rangeOfBlockInstructions.lowerBoundary; i <= this.rangeOfBlockInstructions.upperBoundary; ++i) {
            result.add(this.methodInstructions.get(i));
        }
        result.trimToSize();
        return result;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    public boolean covers(int someInstructionIndex) {
        return this.rangeOfBlockInstructions.covers(someInstructionIndex);
    }

    boolean isDirectPredecessorOf(ControlFlowBlock successor) {
        return this.successors.contains(successor);
    }

    boolean isPredecessorOf(ControlFlowBlock possibleSuccessor) {
        boolean result = false;
        for (ControlFlowBlock directSuccessor : this.successors) {
            if (!directSuccessor.equals(possibleSuccessor) && !directSuccessor.isPredecessorOf(possibleSuccessor)) continue;
            result = true;
            break;
        }
        return result;
    }

    boolean isSuccessorOf(ControlFlowBlock possiblePredecessor) {
        return possiblePredecessor.isPredecessorOf(this);
    }

    public AbstractInsnNode getBlockInstructionForIndex(int index) {
        AbstractInsnNode result;
        int resultIndex = this.rangeOfBlockInstructions.lowerBoundary + index;
        try {
            result = this.methodInstructions.get(resultIndex);
        }
        catch (IndexOutOfBoundsException e) {
            result = null;
        }
        return result;
    }

    public int getIndexWithinMethod(int indexWithinBlock) {
        int result = indexWithinBlock + this.rangeOfBlockInstructions.lowerBoundary;
        if (this.rangeOfBlockInstructions.upperBoundary < result) {
            String msgTemplate = "Index would be %d which is bigger than the maximum index of method (%d).";
            String msg = String.format("Index would be %d which is bigger than the maximum index of method (%d).", result, this.rangeOfBlockInstructions.upperBoundary);
            throw new IndexOutOfBoundsException(msg);
        }
        return result;
    }

    public int getIndexWithinBlock(int indexWithinMethod) {
        return indexWithinMethod - this.rangeOfBlockInstructions.lowerBoundary;
    }

    public Set<ControlFlowBlock> getPredecessors() {
        return Collections.unmodifiableSet(this.predecessors);
    }

    public Set<ControlFlowBlock> getSuccessors() {
        return Collections.unmodifiableSet(this.successors);
    }

    @Override
    public int compareTo(ControlFlowBlock o) {
        Integer thisBlockNumber = this.blockNumber;
        Integer otherBlockNumber = o.blockNumber;
        return thisBlockNumber.compareTo(otherBlockNumber);
    }

    public synchronized int hashCode() {
        if (0 == this.hashCode) {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.blockNumber;
            result = 31 * result + this.identifier.hashCode();
            result = 31 * result + this.methodInstructions.hashCode();
            result = 31 * result + this.rangeOfBlockInstructions.hashCode();
            result = 31 * result + this.predecessors.hashCode();
            this.hashCode = result = 31 * result + this.successors.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlFlowBlock)) {
            return false;
        }
        ControlFlowBlock other = (ControlFlowBlock)obj;
        if (this.blockNumber != other.blockNumber) {
            return false;
        }
        if (!this.identifier.equals(other.identifier)) {
            return false;
        }
        if (!this.methodInstructions.equals(other.methodInstructions)) {
            return false;
        }
        if (!this.rangeOfBlockInstructions.equals(other.rangeOfBlockInstructions)) {
            return false;
        }
        if (!this.predecessors.equals(other.predecessors)) {
            return false;
        }
        return this.successors.equals(other.successors);
    }

    public synchronized String toString() {
        if (null == this.stringRepresentation) {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
            builder.append("[blockNumber=").append(this.blockNumber);
            builder.append(", identifier=").append(this.identifier);
            builder.append(", rangeOfBlockInstructionIndices=").append(this.rangeOfBlockInstructions);
            builder.append(", predecessors=").append(ControlFlowBlock.setToString(this.predecessors));
            builder.append(", successors=").append(ControlFlowBlock.setToString(this.successors));
            builder.append(']');
            this.stringRepresentation = builder.toString();
        }
        return this.stringRepresentation;
    }

    private static String setToString(Set<ControlFlowBlock> cfbSet) {
        StringBuilder result = new StringBuilder();
        result.append('{');
        String separator = ", ";
        String sep = "";
        for (ControlFlowBlock controlFlowBlock : cfbSet) {
            result.append(sep).append(controlFlowBlock.getBlockNumber());
            sep = ", ";
        }
        result.append('}');
        return result.toString();
    }

    @ThreadSafe
    public static final class ControlFlowBlockFactory {
        private final String owner;
        private final MethodNode method;
        private final InsnList allInstructions;
        private final List<ControlFlowBlock> controlFlowBlocks;
        private final AtomicInteger currentBlockNumber;
        private final Analyzer<BasicValue> analyser = new Analyzer<BasicValue>((Interpreter)new BasicInterpreter()){

            @Override
            protected void newControlFlowEdge(int src, int dest) {
                this.interlinkControlFlowBlocks(src, dest);
            }

            private void interlinkControlFlowBlocks(int src, int dest) {
                ControlFlowBlock srcBlock = null;
                ControlFlowBlock destBlock = null;
                for (ControlFlowBlock b : ControlFlowBlockFactory.this.controlFlowBlocks) {
                    if (b.covers(src)) {
                        srcBlock = b;
                        continue;
                    }
                    if (!b.covers(dest)) continue;
                    destBlock = b;
                }
                if (null != srcBlock && null != destBlock) {
                    srcBlock.successors.add(destBlock);
                    destBlock.predecessors.add(srcBlock);
                }
            }
        };

        private ControlFlowBlockFactory(String theOwner, MethodNode theMethod) {
            this.method = theMethod;
            this.owner = theOwner;
            this.allInstructions = theMethod.instructions;
            this.controlFlowBlocks = new ArrayList<ControlFlowBlock>();
            this.currentBlockNumber = new AtomicInteger(0);
        }

        public static ControlFlowBlockFactory newInstance(String owner, MethodNode method) {
            Preconditions.checkArgument(!owner.isEmpty());
            ControlFlowBlockFactory result = new ControlFlowBlockFactory(owner, Preconditions.checkNotNull(method));
            result.createAllControlFlowBlockBuilders();
            result.analyseMethod();
            return result;
        }

        private void createAllControlFlowBlockBuilders() {
            Builder builder = this.handleFirstInstruction();
            this.handleRemainingInstructions(builder);
        }

        private Builder handleFirstInstruction() {
            AbstractInsnNode firstInsn = this.allInstructions.get(this.currentBlockNumber.get());
            Builder result = ControlFlowBlockFactory.isLabel(firstInsn) ? this.createNewControlFlowBlockBuilderForLabel(firstInsn) : new Builder(this.currentBlockNumber.getAndIncrement(), "L<Pseudo>", this.allInstructions);
            result.addInstruction(0);
            return result;
        }

        private static boolean isLabel(AbstractInsnNode insn) {
            return 8 == insn.getType();
        }

        private Builder createNewControlFlowBlockBuilderForLabel(AbstractInsnNode insn) {
            LabelNode labelNode = (LabelNode)insn;
            Label label = labelNode.getLabel();
            return new Builder(this.currentBlockNumber.getAndIncrement(), label.toString(), this.allInstructions);
        }

        private void handleRemainingInstructions(Builder controlFlowBlockBuilder) {
            Builder builder = controlFlowBlockBuilder;
            for (int i = 1; i < this.allInstructions.size(); ++i) {
                AbstractInsnNode insn = this.allInstructions.get(i);
                if (ControlFlowBlockFactory.isLabel(insn)) {
                    this.controlFlowBlocks.add(builder.build());
                    builder = this.createNewControlFlowBlockBuilderForLabel(insn);
                }
                builder.addInstruction(i);
            }
            this.controlFlowBlocks.add(builder.build());
        }

        private void analyseMethod() {
            this.tryToAnalyseMethod();
        }

        private void tryToAnalyseMethod() {
            try {
                this.analyser.analyze(this.owner, this.method);
            }
            catch (AnalyzerException e) {
                e.printStackTrace();
            }
        }

        public List<ControlFlowBlock> getAllControlFlowBlocksForMethod() {
            ArrayList<ControlFlowBlock> result = new ArrayList<ControlFlowBlock>(this.controlFlowBlocks.size());
            for (ControlFlowBlock b : this.controlFlowBlocks) {
                if (!b.isNotEmpty()) continue;
                result.add(b);
            }
            result.trimToSize();
            return result;
        }
    }

    @NotThreadSafe
    private static final class Builder {
        private final int blockNumber;
        private final String identifier;
        private final InsnList allInstructions;
        private final SortedSet<Integer> rangeItems;

        public Builder(int theBlockNumber, String theIdentifier, InsnList allInstructions) {
            Preconditions.checkArgument(!theIdentifier.isEmpty());
            this.blockNumber = theBlockNumber;
            this.identifier = theIdentifier;
            this.allInstructions = Preconditions.checkNotNull(allInstructions);
            this.rangeItems = new TreeSet<Integer>();
        }

        public void addInstruction(int instructionIndex) {
            this.rangeItems.add(instructionIndex);
        }

        public ControlFlowBlock build() {
            Range range = Range.newInstance(this.rangeItems);
            return ControlFlowBlock.newInstance(this.blockNumber, this.identifier, this.allInstructions, range);
        }
    }

    @Immutable
    static final class Range {
        public final int lowerBoundary;
        public final int upperBoundary;
        public final List<Integer> allItems;

        private Range(int theLowerBoundary, int theUpperBoundary, List<Integer> allItems) {
            this.lowerBoundary = theLowerBoundary;
            this.upperBoundary = theUpperBoundary;
            this.allItems = Collections.unmodifiableList(allItems);
        }

        public static Range newInstance(SortedSet<Integer> allItems) {
            ArrayList<Integer> allItemsList = new ArrayList<Integer>(allItems.size());
            for (Integer item : new TreeSet<Integer>(allItems)) {
                allItemsList.add(item);
            }
            int lowerBoundary = allItemsList.isEmpty() ? -1 : (Integer)allItemsList.get(0);
            int upperBoundary = allItemsList.isEmpty() ? -1 : (Integer)allItemsList.get(allItemsList.size() - 1);
            return new Range(lowerBoundary, upperBoundary, allItemsList);
        }

        public boolean covers(int index) {
            return this.allItems.contains(index);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.allItems.hashCode();
            result = 31 * result + this.lowerBoundary;
            result = 31 * result + this.upperBoundary;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Range)) {
                return false;
            }
            Range other = (Range)obj;
            if (!this.allItems.equals(other.allItems)) {
                return false;
            }
            if (this.lowerBoundary != other.lowerBoundary) {
                return false;
            }
            return this.upperBoundary == other.upperBoundary;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            builder.append(" [lowerBoundary=").append(this.lowerBoundary).append(", upperBoundary=").append(this.upperBoundary);
            builder.append(", allItems=").append(this.allItems).append(']');
            return builder.toString();
        }
    }
}

