/*
 * Decompiled with CFR 0.152.
 */
package org.mutabilitydetector.unittesting;

import org.hamcrest.Matcher;
import org.mutabilitydetector.AnalysisResult;
import org.mutabilitydetector.IsImmutable;
import org.mutabilitydetector.MutableReasonDetail;
import org.mutabilitydetector.unittesting.matchers.IsImmutableMatcher;
import org.mutabilitydetector.unittesting.matchers.reasons.NoReasonsAllowed;

public final class MutabilityMatchers {
    private MutabilityMatchers() throws InstantiationException {
        throw new InstantiationException("This class is not created for instantiation");
    }

    public static Matcher<MutableReasonDetail> noReasonsAllowed() {
        return new NoReasonsAllowed();
    }

    public static Matcher<AnalysisResult> areImmutable() {
        return IsImmutableMatcher.hasIsImmutableStatusOf(IsImmutable.IMMUTABLE);
    }

    public static Matcher<AnalysisResult> areEffectivelyImmutable() {
        return IsImmutableMatcher.hasIsImmutableStatusOf(IsImmutable.EFFECTIVELY_IMMUTABLE);
    }

    public static Matcher<AnalysisResult> areNotImmutable() {
        return IsImmutableMatcher.hasIsImmutableStatusOf(IsImmutable.NOT_IMMUTABLE);
    }
}

