/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import org.neo4j.backup.TheBackupInterface;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.ServerUtil;
import org.neo4j.com.StoreWriter;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.util.StringLogger;

class BackupImpl
implements TheBackupInterface {
    private StringLogger logger;
    private SPI spi;
    private final XaDataSourceManager xaDataSourceManager;
    private final KernelPanicEventGenerator kpeg;

    public BackupImpl(StringLogger logger, SPI spi, XaDataSourceManager xaDataSourceManager, KernelPanicEventGenerator kpeg) {
        this.logger = logger;
        this.spi = spi;
        this.xaDataSourceManager = xaDataSourceManager;
        this.kpeg = kpeg;
    }

    @Override
    public Response<Void> fullBackup(StoreWriter writer) {
        RequestContext context = ServerUtil.rotateLogsAndStreamStoreFiles((String)this.spi.getStoreDir(), (XaDataSourceManager)this.xaDataSourceManager, (KernelPanicEventGenerator)this.kpeg, (StringLogger)this.logger, (boolean)false, (StoreWriter)writer);
        writer.done();
        return this.packResponse(context);
    }

    @Override
    public Response<Void> incrementalBackup(RequestContext context) {
        return this.packResponse(context);
    }

    private Response<Void> packResponse(RequestContext context) {
        if (GraphDatabaseSetting.osIsWindows()) {
            ServerUtil.rotateLogs((XaDataSourceManager)this.xaDataSourceManager, (KernelPanicEventGenerator)this.kpeg, (StringLogger)this.logger);
        }
        return ServerUtil.packResponse((StoreId)this.spi.getStoreId(), (XaDataSourceManager)this.xaDataSourceManager, (RequestContext)context, null, (Predicate)ServerUtil.ALL);
    }

    public static interface SPI {
        public String getStoreDir();

        public StoreId getStoreId();
    }
}

