/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.IOException;
import org.jboss.netty.channel.Channel;
import org.neo4j.backup.BackupClient;
import org.neo4j.backup.TheBackupInterface;
import org.neo4j.com.RequestContext;
import org.neo4j.com.RequestType;
import org.neo4j.com.Server;
import org.neo4j.com.TxChecksumVerifier;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.tooling.Clock;

class BackupServer
extends Server<TheBackupInterface, Object> {
    static final byte PROTOCOL_VERSION = 1;
    private final BackupClient.BackupRequestType[] contexts = BackupClient.BackupRequestType.values();
    static int DEFAULT_PORT = 6362;
    static final int FRAME_LENGTH = 0x400000;

    public BackupServer(TheBackupInterface requestTarget, final HostnamePort server, Logging logging, Monitors monitors) throws IOException {
        super((Object)requestTarget, new Server.Configuration(){

            public long getOldChannelThreshold() {
                return 20000L;
            }

            public int getMaxConcurrentTransactions() {
                return 3;
            }

            public int getChunkSize() {
                return 0x400000;
            }

            public HostnamePort getServerAddress() {
                return server;
            }
        }, logging, 0x400000, (byte)1, TxChecksumVerifier.ALWAYS_MATCH, Clock.REAL_CLOCK, monitors);
    }

    protected void responseWritten(RequestType<TheBackupInterface> type, Channel channel, RequestContext context) {
    }

    protected RequestType<TheBackupInterface> getRequestContext(byte id) {
        return this.contexts[id];
    }

    protected void finishOffChannel(Channel channel, RequestContext context) {
    }
}

