/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.neo4j.backup.BackupClient;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.backup.VerificationLevel;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.ServerUtil;
import org.neo4j.com.StoreWriter;
import org.neo4j.com.ToFileStoreWriter;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TxExtractor;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.ProgressIndicator;
import org.neo4j.helpers.Triplet;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigParam;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.LogIoUtils;
import org.neo4j.kernel.impl.transaction.xaframework.NoSuchLogVersionException;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

class BackupService {
    BackupService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BackupOutcome doFullBackup(String sourceHostNameOrIp, int sourcePort, String targetDirectory, boolean checkConsistency, Config tuningConfiguration) {
        boolean consistent;
        Map<String, Long> lastCommittedTxs;
        block34: {
            if (this.directoryContainsDb(targetDirectory)) {
                throw new RuntimeException(targetDirectory + " already contains a database");
            }
            BackupClient client = new BackupClient(sourceHostNameOrIp, sourcePort, (Logging)new DevNullLoggingService(), new Monitors(), null);
            client.start();
            long timestamp = System.currentTimeMillis();
            lastCommittedTxs = Collections.emptyMap();
            consistent = !checkConsistency;
            try {
                block33: {
                    Response<Void> response = client.fullBackup(this.decorateWithProgressIndicator((StoreWriter)new ToFileStoreWriter(new File(targetDirectory))));
                    GraphDatabaseAPI targetDb = BackupService.startTemporaryDb(targetDirectory, VerificationLevel.NONE);
                    try {
                        lastCommittedTxs = this.unpackResponse(response, (XaDataSourceManager)targetDb.getDependencyResolver().resolveDependency(XaDataSourceManager.class), ServerUtil.txHandlerForFullCopy());
                        HashSet<String> noTxPresent = new HashSet<String>();
                        for (XaDataSource ds : targetDb.getXaDataSourceManager().getAllRegisteredDataSources()) {
                            long lastTx = ds.getLastCommittedTxId();
                            try {
                                ds.getMasterForCommittedTx(lastTx);
                            }
                            catch (NoSuchLogVersionException e) {
                                noTxPresent.add(ds.getName());
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        if (noTxPresent.isEmpty()) break block33;
                        BackupClient recoveryClient = new BackupClient(sourceHostNameOrIp, sourcePort, (Logging)targetDb.getDependencyResolver().resolveDependency(Logging.class), (Monitors)targetDb.getDependencyResolver().resolveDependency(Monitors.class), targetDb.getStoreId());
                        recoveryClient.start();
                        Response<Void> recoveryResponse = null;
                        HashMap<String, Long> recoveryDiff = new HashMap<String, Long>();
                        for (String ds : noTxPresent) {
                            recoveryDiff.put(ds, -1L);
                        }
                        RequestContext recoveryCtx = this.addDiffToSlaveContext(this.slaveContextOf(targetDb), recoveryDiff);
                        try {
                            recoveryResponse = recoveryClient.incrementalBackup(recoveryCtx);
                            TransactionStream txs = recoveryResponse.transactions();
                            ByteBuffer scratch = ByteBuffer.allocate(64);
                            while (txs.hasNext()) {
                                Triplet tx = (Triplet)txs.next();
                                scratch.clear();
                                XaDataSource ds = targetDb.getXaDataSourceManager().getXaDataSource((String)tx.first());
                                long logVersion = ds.getCurrentLogVersion() - 1L;
                                FileChannel newLog = new RandomAccessFile(ds.getFileName(logVersion), "rw").getChannel();
                                newLog.truncate(0L);
                                LogIoUtils.writeLogHeader((ByteBuffer)scratch, (long)logVersion, (long)-1L);
                                newLog.write(scratch);
                                ReadableByteChannel received = ((TxExtractor)tx.third()).extract();
                                scratch.flip();
                                while (received.read(scratch) > 0) {
                                    scratch.flip();
                                    newLog.write(scratch);
                                    scratch.flip();
                                }
                                newLog.force(false);
                                newLog.close();
                                received.close();
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            try {
                                recoveryClient.stop();
                            }
                            catch (Throwable throwable) {
                                throw new RuntimeException(throwable);
                            }
                            if (recoveryResponse != null) {
                                recoveryResponse.close();
                            }
                            targetDb.shutdown();
                        }
                    }
                    finally {
                        targetDb.shutdown();
                    }
                }
                BackupService.bumpLogFile(targetDirectory, timestamp);
                if (!checkConsistency) break block34;
                StringLogger logger = StringLogger.SYSTEM;
                try {
                    consistent = new ConsistencyCheckService().runFullConsistencyCheck(targetDirectory, tuningConfiguration, ProgressMonitorFactory.textual((OutputStream)System.err), logger);
                }
                catch (ConsistencyCheckIncompleteException e) {
                    e.printStackTrace(System.err);
                }
                finally {
                    logger.flush();
                }
            }
            finally {
                try {
                    client.stop();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        }
        return new BackupOutcome(lastCommittedTxs, consistent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BackupOutcome doIncrementalBackup(String sourceHostNameOrIp, int sourcePort, String targetDirectory, boolean verification) {
        if (!this.directoryContainsDb(targetDirectory)) {
            throw new RuntimeException(targetDirectory + " doesn't contain a database");
        }
        ConfigParam keepLogs = new ConfigParam(){

            public void configure(Map<String, String> config) {
                config.put(GraphDatabaseSettings.keep_logical_logs.name(), "true");
            }
        };
        GraphDatabaseAPI targetDb = BackupService.startTemporaryDb(targetDirectory, VerificationLevel.valueOf(verification), keepLogs);
        long backupStartTime = System.currentTimeMillis();
        BackupOutcome outcome = null;
        try {
            outcome = this.doIncrementalBackup(sourceHostNameOrIp, sourcePort, targetDb);
        }
        finally {
            targetDb.shutdown();
        }
        BackupService.bumpLogFile(targetDirectory, backupStartTime);
        return outcome;
    }

    BackupOutcome doIncrementalBackup(String sourceHostNameOrIp, int sourcePort, GraphDatabaseAPI targetDb) {
        return this.incrementalWithContext(sourceHostNameOrIp, sourcePort, targetDb, this.slaveContextOf(targetDb));
    }

    private RequestContext slaveContextOf(GraphDatabaseAPI graphDb) {
        XaDataSourceManager dsManager = graphDb.getXaDataSourceManager();
        ArrayList<RequestContext.Tx> txs = new ArrayList<RequestContext.Tx>();
        for (XaDataSource ds : dsManager.getAllRegisteredDataSources()) {
            txs.add(RequestContext.lastAppliedTx((String)ds.getName(), (long)ds.getLastCommittedTxId()));
        }
        return RequestContext.anonymous((RequestContext.Tx[])txs.toArray(new RequestContext.Tx[0]));
    }

    private StoreWriter decorateWithProgressIndicator(final StoreWriter actual) {
        return new StoreWriter(){
            private final ProgressIndicator progress = new ProgressIndicator.UnknownEndProgress(1L, "Files copied");
            private int totalFiles;

            public int write(String path, ReadableByteChannel data, ByteBuffer temporaryBuffer, boolean hasData) throws IOException {
                int written = actual.write(path, data, temporaryBuffer, hasData);
                this.progress.update(true, 1L);
                ++this.totalFiles;
                return written;
            }

            public void done() {
                actual.done();
                this.progress.done((long)this.totalFiles);
            }
        };
    }

    boolean directoryContainsDb(String targetDirectory) {
        return new File(targetDirectory, "neostore").exists();
    }

    static GraphDatabaseAPI startTemporaryDb(String targetDirectory, ConfigParam ... params) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(OnlineBackupSettings.online_backup_enabled.name(), "false");
        for (ConfigParam param : params) {
            if (param == null) continue;
            param.configure(config);
        }
        return (GraphDatabaseAPI)new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(targetDirectory).setConfig(config).newGraphDatabase();
    }

    private RequestContext addDiffToSlaveContext(RequestContext original, Map<String, Long> diffPerDataSource) {
        RequestContext.Tx[] oldTxs = original.lastAppliedTransactions();
        RequestContext.Tx[] newTxs = new RequestContext.Tx[oldTxs.length];
        for (int i = 0; i < oldTxs.length; ++i) {
            RequestContext.Tx oldTx = oldTxs[i];
            String dsName = oldTx.getDataSourceName();
            long originalTxId = oldTx.getTxId();
            Long diff = diffPerDataSource.get(dsName);
            if (diff == null) {
                diff = 0L;
            }
            long newTxId = originalTxId + diff;
            newTxs[i] = RequestContext.lastAppliedTx((String)dsName, (long)newTxId);
        }
        return RequestContext.anonymous((RequestContext.Tx[])newTxs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BackupOutcome incrementalWithContext(String sourceHostNameOrIp, int sourcePort, GraphDatabaseAPI targetDb, RequestContext context) {
        Map<String, Long> lastCommittedTxs;
        BackupClient client = new BackupClient(sourceHostNameOrIp, sourcePort, (Logging)targetDb.getDependencyResolver().resolveDependency(Logging.class), (Monitors)targetDb.getDependencyResolver().resolveDependency(Monitors.class), targetDb.getStoreId());
        client.start();
        boolean consistent = false;
        try {
            lastCommittedTxs = this.unpackResponse(client.incrementalBackup(context), (XaDataSourceManager)targetDb.getDependencyResolver().resolveDependency(XaDataSourceManager.class), new ProgressTxHandler());
            this.trimLogicalLogCount(targetDb);
            consistent = true;
        }
        finally {
            try {
                client.stop();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        return new BackupOutcome(lastCommittedTxs, consistent);
    }

    private void trimLogicalLogCount(GraphDatabaseAPI targetDb) {
        for (XaDataSource ds : targetDb.getXaDataSourceManager().getAllRegisteredDataSources()) {
            long currentVersion;
            try {
                ds.rotateLogicalLog();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (currentVersion = ds.getCurrentLogVersion() - 1L; ds.getLogicalLogLength(currentVersion) <= 16L && currentVersion > 0L; --currentVersion) {
            }
            --currentVersion;
            while (ds.getLogicalLogLength(currentVersion) > 0L) {
                ds.deleteLogicalLog(currentVersion);
                --currentVersion;
            }
        }
    }

    private Map<String, Long> unpackResponse(Response<Void> response, XaDataSourceManager xaDsm, ServerUtil.TxHandler txHandler) {
        try {
            ServerUtil.applyReceivedTransactions(response, (XaDataSourceManager)xaDsm, (ServerUtil.TxHandler)txHandler);
            return this.extractLastCommittedTxs(xaDsm);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to apply received transactions", e);
        }
    }

    private Map<String, Long> extractLastCommittedTxs(XaDataSourceManager xaDsm) {
        TreeMap<String, Long> lastCommittedTxs = new TreeMap<String, Long>();
        for (XaDataSource ds : xaDsm.getAllRegisteredDataSources()) {
            lastCommittedTxs.put(ds.getName(), ds.getLastCommittedTxId());
        }
        return lastCommittedTxs;
    }

    private static boolean bumpLogFile(String targetDirectory, long toTimestamp) {
        File dbDirectory = new File(targetDirectory);
        File[] candidates = dbDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals("messages.log");
            }
        });
        File previous = null;
        if (candidates.length != 1) {
            return false;
        }
        previous = candidates[0];
        File to = new File(previous.getParentFile(), "messages.log." + toTimestamp);
        return previous.renameTo(to);
    }

    private static class ProgressTxHandler
    implements ServerUtil.TxHandler {
        private final ProgressIndicator progress = new ProgressIndicator.UnknownEndProgress(1000L, "Transactions applied");
        private long count;

        private ProgressTxHandler() {
        }

        public void accept(Triplet<String, Long, TxExtractor> tx, XaDataSource dataSource) {
            this.progress.update(true, 1L);
            ++this.count;
        }

        public void done() {
            this.progress.done(this.count);
        }
    }

    class BackupOutcome {
        private final Map<String, Long> lastCommittedTxs;
        private final boolean consistent;

        BackupOutcome(Map<String, Long> lastCommittedTxs, boolean consistent) {
            this.lastCommittedTxs = lastCommittedTxs;
            this.consistent = consistent;
        }

        public Map<String, Long> getLastCommittedTxs() {
            return Collections.unmodifiableMap(this.lastCommittedTxs);
        }

        public boolean isConsistent() {
            return this.consistent;
        }
    }
}

