/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.util.Map;
import org.neo4j.backup.BackupServer;
import org.neo4j.backup.BackupService;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;

public class OnlineBackup {
    private final String hostNameOrIp;
    private final int port;
    private BackupService.BackupOutcome outcome;

    public static OnlineBackup from(String hostNameOrIp, int port) {
        return new OnlineBackup(hostNameOrIp, port);
    }

    public static OnlineBackup from(String hostNameOrIp) {
        return new OnlineBackup(hostNameOrIp, BackupServer.DEFAULT_PORT);
    }

    private OnlineBackup(String hostNameOrIp, int port) {
        this.hostNameOrIp = hostNameOrIp;
        this.port = port;
    }

    public OnlineBackup full(String targetDirectory) {
        this.outcome = new BackupService().doFullBackup(this.hostNameOrIp, this.port, targetDirectory, true, this.defaultConfig());
        return this;
    }

    public OnlineBackup full(String targetDirectory, boolean verification) {
        this.outcome = new BackupService().doFullBackup(this.hostNameOrIp, this.port, targetDirectory, verification, this.defaultConfig());
        return this;
    }

    public OnlineBackup full(String targetDirectory, boolean verification, Config tuningConfiguration) {
        this.outcome = new BackupService().doFullBackup(this.hostNameOrIp, this.port, targetDirectory, verification, tuningConfiguration);
        return this;
    }

    public OnlineBackup incremental(String targetDirectory) {
        this.outcome = new BackupService().doIncrementalBackup(this.hostNameOrIp, this.port, targetDirectory, true);
        return this;
    }

    public OnlineBackup incremental(String targetDirectory, boolean verification) {
        this.outcome = new BackupService().doIncrementalBackup(this.hostNameOrIp, this.port, targetDirectory, verification);
        return this;
    }

    public OnlineBackup incremental(GraphDatabaseAPI targetDb) {
        this.outcome = new BackupService().doIncrementalBackup(this.hostNameOrIp, this.port, targetDb);
        return this;
    }

    public Map<String, Long> getLastCommittedTxs() {
        return this.outcome().getLastCommittedTxs();
    }

    public boolean isConsistent() {
        return this.outcome().isConsistent();
    }

    private BackupService.BackupOutcome outcome() {
        if (this.outcome == null) {
            throw new IllegalStateException("No outcome yet. Please call full or incremental backup first");
        }
        return this.outcome;
    }

    private Config defaultConfig() {
        return new Config(MapUtil.stringMap((String[])new String[0]), new Class[]{GraphDatabaseSettings.class, ConsistencyCheckSettings.class});
    }
}

