/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.net.InetSocketAddress;
import java.net.URI;
import org.neo4j.backup.BackupImpl;
import org.neo4j.backup.BackupServer;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.cluster.BindingListener;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.com.BindingNotifier;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.com.ServerUtil;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

public class OnlineBackupKernelExtension
implements Lifecycle {
    public static final String BACKUP = "backup";
    private Config config;
    private GraphDatabaseAPI graphDatabaseAPI;
    private XaDataSourceManager xaDataSourceManager;
    private KernelPanicEventGenerator kpeg;
    private Logging logging;
    private final Monitors monitors;
    private BackupServer server;
    private URI backupUri;
    private volatile URI me;

    public OnlineBackupKernelExtension(Config config, GraphDatabaseAPI graphDatabaseAPI, XaDataSourceManager xaDataSourceManager, KernelPanicEventGenerator kpeg, Logging logging, Monitors monitors) {
        this.config = config;
        this.graphDatabaseAPI = graphDatabaseAPI;
        this.xaDataSourceManager = xaDataSourceManager;
        this.kpeg = kpeg;
        this.logging = logging;
        this.monitors = monitors;
    }

    public void init() throws Throwable {
    }

    public void start() throws Throwable {
        if (((Boolean)this.config.get(OnlineBackupSettings.online_backup_enabled)).booleanValue()) {
            BackupImpl backup = new BackupImpl(this.logging.getMessagesLog(BackupImpl.class), new BackupImpl.SPI(){

                @Override
                public String getStoreDir() {
                    return OnlineBackupKernelExtension.this.graphDatabaseAPI.getStoreDir();
                }

                @Override
                public StoreId getStoreId() {
                    return OnlineBackupKernelExtension.this.graphDatabaseAPI.getStoreId();
                }
            }, this.xaDataSourceManager, this.kpeg);
            try {
                this.server = new BackupServer(backup, (HostnamePort)this.config.get(OnlineBackupSettings.online_backup_server), this.logging, this.monitors);
                this.server.init();
                this.server.start();
                try {
                    ((ClusterMemberEvents)this.graphDatabaseAPI.getDependencyResolver().resolveDependency(ClusterMemberEvents.class)).addClusterMemberListener((ClusterMemberListener)new StartBindingListener());
                    ((BindingNotifier)this.graphDatabaseAPI.getDependencyResolver().resolveDependency(BindingNotifier.class)).addBindingListener(new BindingListener(){

                        public void listeningAt(URI myUri) {
                            OnlineBackupKernelExtension.this.me = myUri;
                        }
                    });
                }
                catch (NoClassDefFoundError e) {
                }
                catch (IllegalArgumentException e) {}
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    public void stop() throws Throwable {
        if (this.server != null) {
            this.server.stop();
            this.server.shutdown();
            this.server = null;
            try {
                ClusterMemberAvailability client = (ClusterMemberAvailability)this.graphDatabaseAPI.getDependencyResolver().resolveDependency(ClusterMemberAvailability.class);
                client.memberIsUnavailable(BACKUP);
            }
            catch (NoClassDefFoundError e) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void shutdown() throws Throwable {
    }

    private class StartBindingListener
    extends ClusterMemberListener.Adapter {
        private StartBindingListener() {
        }

        public void memberIsAvailable(String role, InstanceId available, URI availableAtUri) {
            if (((ClusterClient)OnlineBackupKernelExtension.this.graphDatabaseAPI.getDependencyResolver().resolveDependency(ClusterClient.class)).getServerId().equals((Object)available) && "master".equals(role)) {
                try {
                    ClusterMemberAvailability ha = (ClusterMemberAvailability)OnlineBackupKernelExtension.this.graphDatabaseAPI.getDependencyResolver().resolveDependency(ClusterMemberAvailability.class);
                    OnlineBackupKernelExtension.this.backupUri = URI.create("backup://" + (ServerUtil.getHostString((InetSocketAddress)OnlineBackupKernelExtension.this.server.getSocketAddress()).contains("0.0.0.0") ? OnlineBackupKernelExtension.this.me.getHost() : ServerUtil.getHostString((InetSocketAddress)OnlineBackupKernelExtension.this.server.getSocketAddress())) + ":" + OnlineBackupKernelExtension.this.server.getSocketAddress().getPort());
                    ha.memberIsAvailable(OnlineBackupKernelExtension.BACKUP, OnlineBackupKernelExtension.this.backupUri);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        }

        public void memberIsUnavailable(String role, InstanceId unavailableId) {
            if (((ClusterClient)OnlineBackupKernelExtension.this.graphDatabaseAPI.getDependencyResolver().resolveDependency(ClusterClient.class)).getServerId().equals((Object)unavailableId) && "master".equals(role)) {
                try {
                    ClusterMemberAvailability ha = (ClusterMemberAvailability)OnlineBackupKernelExtension.this.graphDatabaseAPI.getDependencyResolver().resolveDependency(ClusterMemberAvailability.class);
                    OnlineBackupKernelExtension.this.backupUri = URI.create("backup://" + (ServerUtil.getHostString((InetSocketAddress)OnlineBackupKernelExtension.this.server.getSocketAddress()).contains("0.0.0.0") ? OnlineBackupKernelExtension.this.me.getHost() : ServerUtil.getHostString((InetSocketAddress)OnlineBackupKernelExtension.this.server.getSocketAddress())) + ":" + OnlineBackupKernelExtension.this.server.getSocketAddress().getPort());
                    ha.memberIsUnavailable(OnlineBackupKernelExtension.BACKUP);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        }
    }
}

