/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Map;
import org.neo4j.backup.BackupService;
import org.neo4j.backup.VerificationLevel;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.ProgressIndicator;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigParam;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreAccess;
import org.neo4j.kernel.impl.nioneo.xa.Command;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.impl.transaction.xaframework.LogIoUtils;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;

class RebuildFromLogs {
    private static final FileSystemAbstraction FS = new DefaultFileSystemAbstraction();
    private final XaDataSource nioneo;
    private final StoreAccess stores;

    RebuildFromLogs(GraphDatabaseAPI graphdb) {
        this.nioneo = RebuildFromLogs.getDataSource(graphdb, "nioneodb");
        this.stores = new StoreAccess(graphdb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RebuildFromLogs applyTransactionsFrom(ProgressIndicator progress, File sourceDir) throws IOException {
        LogExtractor extractor = null;
        try {
            long txId;
            extractor = LogExtractor.from((FileSystemAbstraction)FS, (File)sourceDir, (ByteCounterMonitor)((ByteCounterMonitor)new Monitors().newMonitor(ByteCounterMonitor.class, new String[0])));
            InMemoryLogBuffer buffer = new InMemoryLogBuffer();
            while ((txId = extractor.extractNext((LogBuffer)buffer)) != -1L) {
                this.applyTransaction(txId, (ReadableByteChannel)buffer);
                if (progress != null) {
                    progress.update(false, txId);
                }
                buffer.reset();
            }
        }
        finally {
            if (extractor != null) {
                extractor.close();
            }
        }
        return this;
    }

    public void applyTransaction(long txId, ReadableByteChannel txData) throws IOException {
        this.nioneo.applyCommittedTransaction(txId, txData);
    }

    private static XaDataSource getDataSource(GraphDatabaseAPI graphdb, String name) {
        XaDataSource datasource = graphdb.getXaDataSourceManager().getXaDataSource(name);
        if (datasource == null) {
            throw new NullPointerException("Could not access " + name);
        }
        return datasource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ProgressIndicator.SimpleProgress progress;
        long maxFileId;
        if (args == null) {
            RebuildFromLogs.printUsage(new String[0]);
            return;
        }
        Args params = new Args(args);
        boolean full = params.getBoolean("full", Boolean.valueOf(false), Boolean.valueOf(true));
        args = params.orphans().toArray(new String[0]);
        if (args.length != 2) {
            RebuildFromLogs.printUsage("Exactly two positional arguments expected: <source dir with logs> <target dir for graphdb>, got " + args.length);
            System.exit(-1);
            return;
        }
        File source = new File(args[0]);
        File target = new File(args[1]);
        if (!source.isDirectory()) {
            RebuildFromLogs.printUsage(source + " is not a directory");
            System.exit(-1);
            return;
        }
        if (target.exists()) {
            if (target.isDirectory()) {
                if (new BackupService().directoryContainsDb(target.getAbsolutePath())) {
                    RebuildFromLogs.printUsage("target graph database already exists");
                    System.exit(-1);
                    return;
                }
                System.err.println("WARNING: the directory " + target + " already exists");
            } else {
                RebuildFromLogs.printUsage(target + " is a file");
                System.exit(-1);
                return;
            }
        }
        if ((maxFileId = RebuildFromLogs.findMaxLogFileId(source)) < 0L) {
            RebuildFromLogs.printUsage("Inconsistent number of log files found in " + source);
            System.exit(-1);
            return;
        }
        long txCount = RebuildFromLogs.findLastTransactionId(source, "nioneo_logical.log.v" + maxFileId);
        String txdifflog = params.get("txdifflog", null, new File(target, "txdiff.log").getAbsolutePath());
        GraphDatabaseAPI graphdb = BackupService.startTemporaryDb(target.getAbsolutePath(), new TxDiffLogConfig(full ? VerificationLevel.FULL_WITH_LOGGING : VerificationLevel.LOGGING, txdifflog));
        if (txCount < 0L) {
            progress = null;
            System.err.println("Unable to report progress, cannot find highest txId, attempting rebuild anyhow.");
        } else {
            progress = ProgressIndicator.SimpleProgress.textual((PrintStream)System.err, (long)txCount);
            System.err.printf("Rebuilding store from %s transactions %n", txCount);
        }
        try {
            try {
                RebuildFromLogs rebuilder = new RebuildFromLogs(graphdb).applyTransactionsFrom((ProgressIndicator)progress, source);
                if (progress != null) {
                    progress.done(txCount);
                }
                if (!full) {
                    rebuilder.checkConsistency();
                }
            }
            finally {
                graphdb.shutdown();
            }
        }
        catch (Exception e) {
            System.err.println();
            e.printStackTrace(System.err);
            System.exit(-1);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long findLastTransactionId(File storeDir, String logFileName) {
        long txId;
        try {
            FileChannel channel = new RandomAccessFile(new File(storeDir, logFileName), "r").getChannel();
            try {
                LogEntry entry;
                ByteBuffer buffer = ByteBuffer.allocateDirect(713);
                txId = LogIoUtils.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)channel, (boolean)true)[1];
                CommandFactory cf = new CommandFactory();
                while ((entry = LogIoUtils.readEntry((ByteBuffer)buffer, (ReadableByteChannel)channel, (XaCommandFactory)cf)) != null) {
                    if (!(entry instanceof LogEntry.Commit)) continue;
                    txId = ((LogEntry.Commit)entry).getTxId();
                }
            }
            finally {
                if (channel != null) {
                    channel.close();
                }
            }
        }
        catch (IOException e) {
            return -1L;
        }
        return txId;
    }

    private void checkConsistency() throws ConsistencyCheckIncompleteException {
        Config tuningConfiguration = new Config(MapUtil.stringMap((String[])new String[0]), new Class[]{GraphDatabaseSettings.class, ConsistencyCheckSettings.class});
        new FullCheck(tuningConfiguration, ProgressMonitorFactory.textual((OutputStream)System.err)).execute(this.stores, StringLogger.SYSTEM);
    }

    private static void printUsage(String ... msgLines) {
        for (String line : msgLines) {
            System.err.println(line);
        }
        System.err.println(Args.jarUsage(RebuildFromLogs.class, (String[])new String[]{"[-full] <source dir with logs> <target dir for graphdb>"}));
        System.err.println("WHERE:   <source dir>  is the path for where transactions to rebuild from are stored");
        System.err.println("         <target dir>  is the path for where to create the new graph database");
        System.err.println("         -full     --  to run a full check over the entire store for each transaction");
    }

    private static long findMaxLogFileId(File source) {
        return XaLogicalLog.getHighestHistoryLogVersion((FileSystemAbstraction)FS, (File)source, (String)"nioneo_logical.log");
    }

    private static class CommandFactory
    extends XaCommandFactory {
        private CommandFactory() {
        }

        public XaCommand readCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            return Command.readCommand(null, (ReadableByteChannel)byteChannel, (ByteBuffer)buffer);
        }
    }

    private static class TxDiffLogConfig
    implements ConfigParam {
        private final String targetFile;
        private final VerificationLevel level;

        TxDiffLogConfig(VerificationLevel level, String targetFile) {
            this.level = level;
            this.targetFile = targetFile;
        }

        public void configure(Map<String, String> config) {
            if (this.targetFile != null) {
                this.level.configureWithDiffLog(config, this.targetFile);
            } else {
                this.level.configure(config);
            }
        }
    }
}

