/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.PrimitiveRecordCheck;
import org.neo4j.consistency.checking.RecordField;
import org.neo4j.consistency.checking.RelationshipNodeField;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;

class NodeRecordCheck
extends PrimitiveRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> {
    NodeRecordCheck() {
        super(NodeField.RELATIONSHIP);
    }

    private static enum NodeField implements RecordField<NodeRecord, ConsistencyReport.NodeConsistencyReport>,
    ComparativeRecordChecker<NodeRecord, RelationshipRecord, ConsistencyReport.NodeConsistencyReport>
    {
        RELATIONSHIP;


        @Override
        public void checkConsistency(NodeRecord node, ConsistencyReport.NodeConsistencyReport report, RecordAccess records) {
            if (!Record.NO_NEXT_RELATIONSHIP.is(node.getNextRel())) {
                report.forReference(records.relationship(node.getNextRel()), this);
            }
        }

        @Override
        public void checkReference(NodeRecord node, RelationshipRecord relationship, ConsistencyReport.NodeConsistencyReport report, RecordAccess records) {
            if (!relationship.inUse()) {
                report.relationshipNotInUse(relationship);
            } else {
                RelationshipNodeField selectedField = RelationshipNodeField.select(relationship, node);
                if (selectedField == null) {
                    report.relationshipForOtherNode(relationship);
                } else {
                    RelationshipNodeField[] fields = relationship.getFirstNode() == relationship.getSecondNode() ? RelationshipNodeField.values() : new RelationshipNodeField[]{selectedField};
                    for (RelationshipNodeField field : fields) {
                        if (Record.NO_NEXT_RELATIONSHIP.is(field.prev(relationship))) continue;
                        field.notFirstInChain(report, relationship);
                    }
                }
            }
        }

        @Override
        public void checkChange(NodeRecord oldRecord, NodeRecord newRecord, ConsistencyReport.NodeConsistencyReport report, DiffRecordAccess records) {
            if (!(newRecord.inUse() && this.valueFrom(oldRecord) == this.valueFrom(newRecord) || Record.NO_NEXT_RELATIONSHIP.is(this.valueFrom(oldRecord)) || records.changedRelationship(this.valueFrom(oldRecord)) != null)) {
                report.relationshipNotUpdated();
            }
        }

        @Override
        public long valueFrom(NodeRecord record) {
            return record.getNextRel();
        }
    }
}

