/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.Arrays;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.RecordField;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;

public abstract class PrimitiveRecordCheck<RECORD extends PrimitiveRecord, REPORT extends ConsistencyReport.PrimitiveConsistencyReport<RECORD, REPORT>>
implements RecordCheck<RECORD, REPORT> {
    private final RecordField<RECORD, REPORT>[] fields;
    public final ComparativeRecordChecker<RECORD, PrimitiveRecord, REPORT> ownerCheck = new ComparativeRecordChecker<RECORD, PrimitiveRecord, REPORT>(){

        @Override
        public void checkReference(RECORD record, PrimitiveRecord other, REPORT report, RecordAccess records) {
            if (other instanceof NodeRecord) {
                report.multipleOwners((NodeRecord)other);
            } else if (other instanceof RelationshipRecord) {
                report.multipleOwners((RelationshipRecord)other);
            } else if (other instanceof NeoStoreRecord) {
                report.multipleOwners((NeoStoreRecord)other);
            }
        }
    };

    PrimitiveRecordCheck(RecordField<RECORD, REPORT> ... fields) {
        this.fields = Arrays.copyOf(fields, fields.length + 1);
        this.fields[fields.length] = new FirstProperty();
    }

    @Override
    public void check(RECORD record, REPORT report, RecordAccess records) {
        if (!record.inUse()) {
            return;
        }
        for (RecordField<RECORD, REPORT> field : this.fields) {
            field.checkConsistency(record, report, records);
        }
    }

    @Override
    public void checkChange(RECORD oldRecord, RECORD newRecord, REPORT report, DiffRecordAccess records) {
        this.check(newRecord, report, (RecordAccess)records);
        if (oldRecord.inUse()) {
            for (RecordField<RECORD, REPORT> field : this.fields) {
                field.checkChange(oldRecord, newRecord, report, records);
            }
        }
    }

    private class FirstProperty
    implements RecordField<RECORD, REPORT>,
    ComparativeRecordChecker<RECORD, PropertyRecord, REPORT> {
        private FirstProperty() {
        }

        @Override
        public void checkConsistency(RECORD record, REPORT report, RecordAccess records) {
            if (!Record.NO_NEXT_PROPERTY.is(record.getNextProp())) {
                report.forReference(records.property(record.getNextProp()), this);
            }
        }

        @Override
        public long valueFrom(RECORD record) {
            return record.getNextProp();
        }

        @Override
        public void checkChange(RECORD oldRecord, RECORD newRecord, REPORT report, DiffRecordAccess records) {
            if (!(newRecord.inUse() && this.valueFrom(oldRecord) == this.valueFrom(newRecord) || Record.NO_NEXT_PROPERTY.is(this.valueFrom(oldRecord)) || records.changedProperty(this.valueFrom(oldRecord)) != null)) {
                report.propertyNotUpdated();
            }
        }

        @Override
        public void checkReference(RECORD record, PropertyRecord property, REPORT report, RecordAccess records) {
            if (!property.inUse()) {
                report.propertyNotInUse(property);
            } else if (!Record.NO_PREVIOUS_PROPERTY.is(property.getPrevProp())) {
                report.propertyNotFirstInChain(property);
            }
        }
    }
}

