/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.incremental.intercept;

import org.neo4j.consistency.checking.incremental.DiffCheck;
import org.neo4j.consistency.checking.incremental.FullDiffCheck;
import org.neo4j.consistency.checking.incremental.IncrementalDiffCheck;
import org.neo4j.consistency.checking.incremental.LoggingDiffCheck;
import org.neo4j.consistency.checking.incremental.intercept.CheckingTransactionInterceptorProvider;
import org.neo4j.kernel.impl.util.StringLogger;

public class InconsistencyLoggingTransactionInterceptorProvider
extends CheckingTransactionInterceptorProvider {
    public static final String NAME = "inconsistencylog";

    public InconsistencyLoggingTransactionInterceptorProvider() {
        super(NAME);
    }

    @Override
    DiffCheck createChecker(String mode, StringLogger logger) {
        CheckerMode checkerMode;
        try {
            checkerMode = CheckerMode.valueOf(mode.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
        return new LoggingDiffCheck(checkerMode.createChecker(logger), logger);
    }

    public static enum CheckerMode {
        FULL{

            @Override
            DiffCheck createChecker(StringLogger logger) {
                return new FullDiffCheck(logger);
            }
        }
        ,
        DIFF{

            @Override
            DiffCheck createChecker(StringLogger logger) {
                return new IncrementalDiffCheck(logger);
            }
        };


        abstract DiffCheck createChecker(StringLogger var1);
    }
}

