/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.repair;

import org.neo4j.consistency.checking.old.InconsistencyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;

public enum RelationshipChainField {
    FIRST_NEXT(true, Record.NO_NEXT_RELATIONSHIP, InconsistencyType.ReferenceInconsistency.SOURCE_NEXT_NOT_IN_USE, null, InconsistencyType.ReferenceInconsistency.SOURCE_NEXT_DIFFERENT_CHAIN){

        @Override
        public long relOf(RelationshipRecord rel) {
            return rel.getFirstNextRel();
        }

        @Override
        public boolean invConsistent(RelationshipRecord rel, RelationshipRecord other) {
            long node = this.getNode(rel);
            if (other.getFirstNode() == node) {
                return other.getFirstPrevRel() == rel.getId();
            }
            if (other.getSecondNode() == node) {
                return other.getSecondPrevRel() == rel.getId();
            }
            return false;
        }
    }
    ,
    FIRST_PREV(true, Record.NO_PREV_RELATIONSHIP, InconsistencyType.ReferenceInconsistency.SOURCE_PREV_NOT_IN_USE, InconsistencyType.ReferenceInconsistency.SOURCE_NO_BACKREF, InconsistencyType.ReferenceInconsistency.SOURCE_PREV_DIFFERENT_CHAIN){

        @Override
        public long relOf(RelationshipRecord rel) {
            return rel.getFirstPrevRel();
        }

        @Override
        public Long nodeOf(RelationshipRecord rel) {
            return this.getNode(rel);
        }

        @Override
        public boolean invConsistent(RelationshipRecord rel, RelationshipRecord other) {
            long node = this.getNode(rel);
            if (other.getFirstNode() == node) {
                return other.getFirstNextRel() == rel.getId();
            }
            if (other.getSecondNode() == node) {
                return other.getSecondNextRel() == rel.getId();
            }
            return false;
        }
    }
    ,
    SECOND_NEXT(false, Record.NO_NEXT_RELATIONSHIP, InconsistencyType.ReferenceInconsistency.TARGET_NEXT_NOT_IN_USE, null, InconsistencyType.ReferenceInconsistency.TARGET_NEXT_DIFFERENT_CHAIN){

        @Override
        public long relOf(RelationshipRecord rel) {
            return rel.getSecondNextRel();
        }

        @Override
        public boolean invConsistent(RelationshipRecord rel, RelationshipRecord other) {
            long node = this.getNode(rel);
            if (other.getFirstNode() == node) {
                return other.getFirstPrevRel() == rel.getId();
            }
            if (other.getSecondNode() == node) {
                return other.getSecondPrevRel() == rel.getId();
            }
            return false;
        }
    }
    ,
    SECOND_PREV(false, Record.NO_PREV_RELATIONSHIP, InconsistencyType.ReferenceInconsistency.TARGET_PREV_NOT_IN_USE, InconsistencyType.ReferenceInconsistency.TARGET_NO_BACKREF, InconsistencyType.ReferenceInconsistency.TARGET_PREV_DIFFERENT_CHAIN){

        @Override
        public long relOf(RelationshipRecord rel) {
            return rel.getSecondPrevRel();
        }

        @Override
        public Long nodeOf(RelationshipRecord rel) {
            return this.getNode(rel);
        }

        @Override
        public boolean invConsistent(RelationshipRecord rel, RelationshipRecord other) {
            long node = this.getNode(rel);
            if (other.getFirstNode() == node) {
                return other.getFirstNextRel() == rel.getId();
            }
            if (other.getSecondNode() == node) {
                return other.getSecondNextRel() == rel.getId();
            }
            return false;
        }
    };

    public final InconsistencyType.ReferenceInconsistency notInUse;
    public final InconsistencyType.ReferenceInconsistency noBackReference;
    public final InconsistencyType.ReferenceInconsistency differentChain;
    private final boolean first;
    public final long none;

    private RelationshipChainField(boolean first, Record none, InconsistencyType.ReferenceInconsistency notInUse, InconsistencyType.ReferenceInconsistency noBackReference, InconsistencyType.ReferenceInconsistency differentChain) {
        this.first = first;
        this.none = none.intValue();
        this.notInUse = notInUse;
        this.noBackReference = noBackReference;
        this.differentChain = differentChain;
    }

    public abstract boolean invConsistent(RelationshipRecord var1, RelationshipRecord var2);

    long getNode(RelationshipRecord rel) {
        return this.first ? rel.getFirstNode() : rel.getSecondNode();
    }

    public abstract long relOf(RelationshipRecord var1);

    public Long nodeOf(RelationshipRecord rel) {
        return null;
    }
}

