/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store;

import java.util.Collection;
import org.neo4j.consistency.store.DiffRecordStore;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.AbstractNameRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.kernel.impl.nioneo.store.StoreAccess;
import org.neo4j.kernel.impl.nioneo.xa.CommandRecordVisitor;

public class DiffStore
extends StoreAccess
implements CommandRecordVisitor {
    private NeoStoreRecord masterRecord;

    public DiffStore(NeoStore store) {
        super(store);
    }

    protected <R extends AbstractBaseRecord> RecordStore<R> wrapStore(RecordStore<R> store) {
        return new DiffRecordStore<R>(store);
    }

    public RecordStore<?>[] allStores() {
        return super.allStores();
    }

    protected void apply(RecordStore.Processor processor, RecordStore<?> store) {
        processor.applyById(store, (Iterable)((DiffRecordStore)store));
    }

    public void visitNode(NodeRecord record) {
        this.getNodeStore().forceUpdateRecord(record);
        record = this.getNodeStore().forceGetRaw(record);
        if (record.inUse()) {
            this.markProperty(record.getNextProp(), record.getId(), -1L);
            this.markRelationship(record.getNextRel());
        }
    }

    public void visitRelationship(RelationshipRecord record) {
        this.getRelationshipStore().forceUpdateRecord(record);
        record = this.getRelationshipStore().forceGetRaw(record);
        if (record.inUse()) {
            this.getNodeStore().markDirty(record.getFirstNode());
            this.getNodeStore().markDirty(record.getSecondNode());
            this.markProperty(record.getNextProp(), -1L, record.getId());
            this.markRelationship(record.getFirstNextRel());
            this.markRelationship(record.getFirstPrevRel());
            this.markRelationship(record.getSecondNextRel());
            this.markRelationship(record.getSecondPrevRel());
        }
    }

    private void markRelationship(long rel) {
        if (!Record.NO_NEXT_RELATIONSHIP.is(rel)) {
            this.getRelationshipStore().markDirty(rel);
        }
    }

    private void markProperty(long prop, long nodeId, long relId) {
        if (!Record.NO_NEXT_PROPERTY.is(prop)) {
            RecordStore store = this.getPropertyStore();
            PropertyRecord record = (PropertyRecord)store.forceGetRaw(prop);
            if (nodeId != -1L) {
                record.setNodeId(nodeId);
            } else if (relId != -1L) {
                record.setRelId(relId);
            }
            store.updateRecord(record);
        }
    }

    public void visitProperty(PropertyRecord record) {
        this.getPropertyStore().forceUpdateRecord(record);
        this.updateDynamic(record);
        record = this.getPropertyStore().forceGetRaw(record);
        this.updateDynamic(record);
        if (record.inUse()) {
            this.markProperty(record.getNextProp(), record.getNodeId(), record.getRelId());
            this.markProperty(record.getPrevProp(), record.getNodeId(), record.getRelId());
        }
    }

    private void updateDynamic(PropertyRecord record) {
        for (PropertyBlock block : record.getPropertyBlocks()) {
            this.updateDynamic(block.getValueRecords());
        }
        this.updateDynamic(record.getDeletedRecords());
    }

    private void updateDynamic(Collection<DynamicRecord> records) {
        for (DynamicRecord record : records) {
            RecordStore store = record.getType() == PropertyType.STRING.intValue() ? this.getStringStore() : this.getArrayStore();
            store.forceUpdateRecord(record);
            if (Record.NO_NEXT_BLOCK.is(record.getNextBlock())) continue;
            this.getBlockStore(record.getType()).markDirty(record.getNextBlock());
        }
    }

    private DiffRecordStore getBlockStore(int type) {
        if (type == PropertyType.STRING.intValue()) {
            return this.getStringStore();
        }
        return this.getArrayStore();
    }

    public void visitPropertyIndex(PropertyIndexRecord record) {
        this.visitNameStore(this.getPropertyIndexStore(), (RecordStore<DynamicRecord>)this.getPropertyKeyStore(), record);
    }

    public void visitRelationshipType(RelationshipTypeRecord record) {
        this.visitNameStore(this.getRelationshipTypeStore(), (RecordStore<DynamicRecord>)this.getTypeNameStore(), record);
    }

    private <R extends AbstractNameRecord> void visitNameStore(RecordStore<R> store, RecordStore<DynamicRecord> nameStore, R record) {
        store.forceUpdateRecord(record);
        for (DynamicRecord key : record.getNameRecords()) {
            nameStore.forceUpdateRecord((AbstractBaseRecord)key);
        }
    }

    public void visitNeoStore(NeoStoreRecord record) {
        this.masterRecord = record;
    }

    public DiffRecordStore<NodeRecord> getNodeStore() {
        return (DiffRecordStore)super.getNodeStore();
    }

    public DiffRecordStore<RelationshipRecord> getRelationshipStore() {
        return (DiffRecordStore)super.getRelationshipStore();
    }

    public DiffRecordStore<PropertyRecord> getPropertyStore() {
        return (DiffRecordStore)super.getPropertyStore();
    }

    public DiffRecordStore<DynamicRecord> getStringStore() {
        return (DiffRecordStore)super.getStringStore();
    }

    public DiffRecordStore<DynamicRecord> getArrayStore() {
        return (DiffRecordStore)super.getArrayStore();
    }

    public DiffRecordStore<RelationshipTypeRecord> getRelationshipTypeStore() {
        return (DiffRecordStore)super.getRelationshipTypeStore();
    }

    public DiffRecordStore<DynamicRecord> getTypeNameStore() {
        return (DiffRecordStore)super.getTypeNameStore();
    }

    public DiffRecordStore<PropertyIndexRecord> getPropertyIndexStore() {
        return (DiffRecordStore)super.getPropertyIndexStore();
    }

    public DiffRecordStore<DynamicRecord> getPropertyKeyStore() {
        return (DiffRecordStore)super.getPropertyKeyStore();
    }

    public NeoStoreRecord getMasterRecord() {
        return this.masterRecord;
    }
}

