/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store;

import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.DiffStore;
import org.neo4j.consistency.store.DirectRecordReference;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.kernel.impl.nioneo.store.StoreAccess;

public class DirectRecordAccess
implements DiffRecordAccess {
    private final StoreAccess access;

    public DirectRecordAccess(StoreAccess access) {
        this.access = access;
    }

    @Override
    public RecordReference<NodeRecord> node(long id) {
        return new DirectRecordReference<AbstractBaseRecord>(this.access.getNodeStore().forceGetRecord(id), this);
    }

    @Override
    public RecordReference<RelationshipRecord> relationship(long id) {
        return new DirectRecordReference<AbstractBaseRecord>(this.access.getRelationshipStore().forceGetRecord(id), this);
    }

    @Override
    public RecordReference<PropertyRecord> property(long id) {
        return new DirectRecordReference<AbstractBaseRecord>(this.access.getPropertyStore().forceGetRecord(id), this);
    }

    @Override
    public RecordReference<RelationshipTypeRecord> relationshipLabel(int id) {
        return new DirectRecordReference<AbstractBaseRecord>(this.access.getRelationshipTypeStore().forceGetRecord((long)id), this);
    }

    @Override
    public RecordReference<PropertyIndexRecord> propertyKey(int id) {
        return new DirectRecordReference<AbstractBaseRecord>(this.access.getPropertyIndexStore().forceGetRecord((long)id), this);
    }

    @Override
    public RecordReference<DynamicRecord> string(long id) {
        return new DirectRecordReference<AbstractBaseRecord>(this.access.getStringStore().forceGetRecord(id), this);
    }

    @Override
    public RecordReference<DynamicRecord> array(long id) {
        return new DirectRecordReference<AbstractBaseRecord>(this.access.getArrayStore().forceGetRecord(id), this);
    }

    @Override
    public RecordReference<DynamicRecord> relationshipLabelName(int id) {
        return new DirectRecordReference<AbstractBaseRecord>(this.access.getTypeNameStore().forceGetRecord((long)id), this);
    }

    @Override
    public RecordReference<DynamicRecord> propertyKeyName(int id) {
        return new DirectRecordReference<AbstractBaseRecord>(this.access.getPropertyKeyStore().forceGetRecord((long)id), this);
    }

    @Override
    public RecordReference<NeoStoreRecord> graph() {
        if (this.access instanceof DiffStore) {
            return new DirectRecordReference<NeoStoreRecord>(((DiffStore)this.access).getMasterRecord(), this);
        }
        return new DirectRecordReference<NeoStoreRecord>(this.access.getRawNeoStore().asRecord(), this);
    }

    @Override
    public RecordReference<NodeRecord> previousNode(long id) {
        return new DirectRecordReference<AbstractBaseRecord>(this.access.getNodeStore().forceGetRaw(id), this);
    }

    @Override
    public RecordReference<RelationshipRecord> previousRelationship(long id) {
        return new DirectRecordReference<AbstractBaseRecord>(this.access.getRelationshipStore().forceGetRaw(id), this);
    }

    @Override
    public RecordReference<PropertyRecord> previousProperty(long id) {
        return new DirectRecordReference<AbstractBaseRecord>(this.access.getPropertyStore().forceGetRaw(id), this);
    }

    @Override
    public NodeRecord changedNode(long id) {
        return this.access instanceof DiffStore ? (NodeRecord)((DiffStore)this.access).getNodeStore().getChangedRecord(id) : null;
    }

    @Override
    public RelationshipRecord changedRelationship(long id) {
        return this.access instanceof DiffStore ? (RelationshipRecord)((DiffStore)this.access).getRelationshipStore().getChangedRecord(id) : null;
    }

    @Override
    public PropertyRecord changedProperty(long id) {
        return this.access instanceof DiffStore ? (PropertyRecord)((DiffStore)this.access).getPropertyStore().getChangedRecord(id) : null;
    }

    @Override
    public DynamicRecord changedString(long id) {
        return this.access instanceof DiffStore ? (DynamicRecord)((DiffStore)this.access).getStringStore().getChangedRecord(id) : null;
    }

    @Override
    public DynamicRecord changedArray(long id) {
        return this.access instanceof DiffStore ? (DynamicRecord)((DiffStore)this.access).getArrayStore().getChangedRecord(id) : null;
    }

    @Override
    public RecordReference<NeoStoreRecord> previousGraph() {
        return new DirectRecordReference<NeoStoreRecord>(this.access.getRawNeoStore().asRecord(), this);
    }
}

