/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabelsField;

public class NodeDynamicLabelOrphanChainStartCheck
implements RecordCheck<DynamicRecord, ConsistencyReport.DynamicLabelConsistencyReport>,
ComparativeRecordChecker<DynamicRecord, DynamicRecord, ConsistencyReport.DynamicLabelConsistencyReport> {
    private static final ComparativeRecordChecker<DynamicRecord, NodeRecord, ConsistencyReport.DynamicLabelConsistencyReport> VALID_NODE_RECORD = new ComparativeRecordChecker<DynamicRecord, NodeRecord, ConsistencyReport.DynamicLabelConsistencyReport>(){

        @Override
        public void checkReference(DynamicRecord record, NodeRecord nodeRecord, CheckerEngine<DynamicRecord, ConsistencyReport.DynamicLabelConsistencyReport> engine, RecordAccess records) {
            if (!nodeRecord.inUse()) {
                engine.report().orphanDynamicLabelRecordDueToInvalidOwner(nodeRecord);
            } else {
                Long dynamicLabelRecordId = NodeLabelsField.fieldDynamicLabelRecordId((long)nodeRecord.getLabelField());
                long recordId = record.getLongId();
                if (dynamicLabelRecordId == null || dynamicLabelRecordId != recordId) {
                    engine.report().orphanDynamicLabelRecordDueToInvalidOwner(nodeRecord);
                }
            }
        }
    };

    @Override
    public void check(DynamicRecord record, CheckerEngine<DynamicRecord, ConsistencyReport.DynamicLabelConsistencyReport> engine, RecordAccess records) {
        if (record.inUse() && record.isStartRecord()) {
            Long ownerId = NodeStore.readOwnerFromDynamicLabelsRecord((DynamicRecord)record);
            if (null == ownerId) {
                engine.report().orphanDynamicLabelRecord();
            } else {
                engine.comparativeCheck(records.node(ownerId), VALID_NODE_RECORD);
            }
        }
    }

    @Override
    public void checkChange(DynamicRecord oldRecord, DynamicRecord newRecord, CheckerEngine<DynamicRecord, ConsistencyReport.DynamicLabelConsistencyReport> engine, DiffRecordAccess records) {
        this.check(newRecord, engine, (RecordAccess)records);
    }

    @Override
    public void checkReference(DynamicRecord record, DynamicRecord record2, CheckerEngine<DynamicRecord, ConsistencyReport.DynamicLabelConsistencyReport> engine, RecordAccess records) {
    }
}

