/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.Arrays;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.LabelChainWalker;
import org.neo4j.consistency.checking.NodeField;
import org.neo4j.consistency.checking.PrimitiveRecordCheck;
import org.neo4j.consistency.checking.RecordField;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.labels.DynamicNodeLabels;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabels;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabelsField;

class NodeRecordCheck
extends PrimitiveRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> {
    NodeRecordCheck() {
        super(RelationshipField.NEXT_REL, LabelsField.LABELS);
    }

    private static enum LabelsField implements RecordField<NodeRecord, ConsistencyReport.NodeConsistencyReport>,
    ComparativeRecordChecker<NodeRecord, LabelTokenRecord, ConsistencyReport.NodeConsistencyReport>
    {
        LABELS{

            @Override
            public void checkConsistency(NodeRecord node, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records) {
                NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
                if (nodeLabels instanceof DynamicNodeLabels) {
                    DynamicNodeLabels dynamicNodeLabels = (DynamicNodeLabels)nodeLabels;
                    long firstRecordId = dynamicNodeLabels.getFirstDynamicRecordId();
                    RecordReference<DynamicRecord> firstRecordReference = records.nodeLabels(firstRecordId);
                    engine.comparativeCheck(firstRecordReference, new LabelChainWalker<NodeRecord, ConsistencyReport.NodeConsistencyReport>(new NodeLabelsComparativeRecordChecker()));
                } else {
                    this.validateLabelIds(nodeLabels.get(null), engine, records);
                }
            }

            private void validateLabelIds(long[] labelIds, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records) {
                for (long labelId : labelIds) {
                    engine.comparativeCheck(records.label((int)labelId), this);
                }
                Arrays.sort(labelIds);
                for (int i = 1; i < labelIds.length; ++i) {
                    if (labelIds[i - 1] != labelIds[i]) continue;
                    engine.report().labelDuplicate(labelIds[i]);
                }
            }

            @Override
            public void checkReference(NodeRecord node, LabelTokenRecord labelTokenRecord, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records) {
                if (!labelTokenRecord.inUse()) {
                    engine.report().labelNotInUse(labelTokenRecord);
                }
            }

            @Override
            public void checkChange(NodeRecord oldRecord, NodeRecord newRecord, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, DiffRecordAccess records) {
            }

            @Override
            public long valueFrom(NodeRecord record) {
                return record.getLabelField();
            }

            class NodeLabelsComparativeRecordChecker
            implements LabelChainWalker.Validator<NodeRecord, ConsistencyReport.NodeConsistencyReport> {
                NodeLabelsComparativeRecordChecker() {
                }

                @Override
                public void onRecordNotInUse(DynamicRecord dynamicRecord, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine) {
                    engine.report().dynamicLabelRecordNotInUse(dynamicRecord);
                }

                @Override
                public void onRecordChainCycle(DynamicRecord record, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine) {
                    engine.report().dynamicRecordChainCycle(record);
                }

                @Override
                public void onWellFormedChain(long[] labelIds, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records) {
                    this.validateLabelIds(labelIds, engine, records);
                }
            }
        };

    }

    private static enum RelationshipField implements RecordField<NodeRecord, ConsistencyReport.NodeConsistencyReport>,
    ComparativeRecordChecker<NodeRecord, RelationshipRecord, ConsistencyReport.NodeConsistencyReport>
    {
        NEXT_REL{

            @Override
            public void checkConsistency(NodeRecord node, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records) {
                if (!Record.NO_NEXT_RELATIONSHIP.is(node.getNextRel())) {
                    engine.comparativeCheck(records.relationship(node.getNextRel()), this);
                }
            }

            @Override
            public void checkReference(NodeRecord node, RelationshipRecord relationship, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records) {
                if (!relationship.inUse()) {
                    engine.report().relationshipNotInUse(relationship);
                } else {
                    NodeField selectedField = NodeField.select(relationship, node);
                    if (selectedField == null) {
                        engine.report().relationshipForOtherNode(relationship);
                    } else {
                        NodeField[] fields = relationship.getFirstNode() == relationship.getSecondNode() ? NodeField.values() : new NodeField[]{selectedField};
                        for (NodeField field : fields) {
                            if (Record.NO_NEXT_RELATIONSHIP.is(field.prev(relationship))) continue;
                            field.notFirstInChain(engine.report(), relationship);
                        }
                    }
                }
            }

            @Override
            public void checkChange(NodeRecord oldRecord, NodeRecord newRecord, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, DiffRecordAccess records) {
                if (!(newRecord.inUse() && this.valueFrom(oldRecord) == this.valueFrom(newRecord) || Record.NO_NEXT_RELATIONSHIP.is(this.valueFrom(oldRecord)) || records.changedRelationship(this.valueFrom(oldRecord)) != null)) {
                    engine.report().relationshipNotUpdated();
                }
            }

            @Override
            public long valueFrom(NodeRecord record) {
                return record.getNextRel();
            }
        };

    }
}

