/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.Arrays;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.LabelChainWalker;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.labels.DynamicNodeLabels;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabels;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabelsField;

public class NodeInUseWithCorrectLabelsCheck<RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport.NodeInUseWithCorrectLabelsReport>
implements ComparativeRecordChecker<RECORD, NodeRecord, REPORT> {
    private final long[] expectedLabels;

    public NodeInUseWithCorrectLabelsCheck(long[] expectedLabels) {
        this.expectedLabels = expectedLabels;
    }

    @Override
    public void checkReference(RECORD record, NodeRecord nodeRecord, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
        if (nodeRecord.inUse()) {
            NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)nodeRecord);
            if (nodeLabels instanceof DynamicNodeLabels) {
                DynamicNodeLabels dynamicNodeLabels = (DynamicNodeLabels)nodeLabels;
                long firstRecordId = dynamicNodeLabels.getFirstDynamicRecordId();
                RecordReference<DynamicRecord> firstRecordReference = records.nodeLabels(firstRecordId);
                engine.comparativeCheck(firstRecordReference, new LabelChainWalker(new ExpectedNodeLabelsChecker(nodeRecord)));
                nodeRecord.getDynamicLabelRecords();
            } else {
                long[] actualLabels = nodeLabels.get(null);
                ConsistencyReport.NodeInUseWithCorrectLabelsReport report = (ConsistencyReport.NodeInUseWithCorrectLabelsReport)engine.report();
                this.validateLabelIds(nodeRecord, actualLabels, report);
            }
        } else {
            ((ConsistencyReport.NodeInUseWithCorrectLabelsReport)engine.report()).nodeNotInUse(nodeRecord);
        }
    }

    private void validateLabelIds(NodeRecord nodeRecord, long[] actualLabels, REPORT report) {
        Arrays.sort(actualLabels);
        for (long expectedLabel : this.expectedLabels) {
            int labelIndex = Arrays.binarySearch(actualLabels, expectedLabel);
            if (labelIndex >= 0) continue;
            report.nodeDoesNotHaveExpectedLabel(nodeRecord, expectedLabel);
        }
    }

    private class ExpectedNodeLabelsChecker
    implements LabelChainWalker.Validator<RECORD, REPORT> {
        private final NodeRecord nodeRecord;

        public ExpectedNodeLabelsChecker(NodeRecord nodeRecord) {
            this.nodeRecord = nodeRecord;
        }

        @Override
        public void onRecordNotInUse(DynamicRecord dynamicRecord, CheckerEngine<RECORD, REPORT> engine) {
        }

        @Override
        public void onRecordChainCycle(DynamicRecord record, CheckerEngine<RECORD, REPORT> engine) {
        }

        @Override
        public void onWellFormedChain(long[] labelIds, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
            NodeInUseWithCorrectLabelsCheck.this.validateLabelIds(this.nodeRecord, labelIds, (ConsistencyReport.NodeInUseWithCorrectLabelsReport)engine.report());
        }
    }
}

