/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.LabelChainWalker;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.labels.DynamicNodeLabels;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabels;
import org.neo4j.kernel.impl.nioneo.store.labels.NodeLabelsField;

public class NodeLabelReader {
    public static <REPORT extends ConsistencyReport> Set<Long> getListOfLabels(NodeRecord nodeRecord, RecordAccess records, CheckerEngine<NodeRecord, REPORT> engine) {
        final HashSet<Long> labels = new HashSet<Long>();
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)nodeRecord);
        if (nodeLabels instanceof DynamicNodeLabels) {
            DynamicNodeLabels dynamicNodeLabels = (DynamicNodeLabels)nodeLabels;
            long firstRecordId = dynamicNodeLabels.getFirstDynamicRecordId();
            RecordReference<DynamicRecord> firstRecordReference = records.nodeLabels(firstRecordId);
            engine.comparativeCheck(firstRecordReference, new LabelChainWalker(new LabelChainWalker.Validator<NodeRecord, REPORT>(){

                @Override
                public void onRecordNotInUse(DynamicRecord dynamicRecord, CheckerEngine<NodeRecord, REPORT> engine) {
                }

                @Override
                public void onRecordChainCycle(DynamicRecord record, CheckerEngine<NodeRecord, REPORT> engine) {
                }

                @Override
                public void onWellFormedChain(long[] labelIds, CheckerEngine<NodeRecord, REPORT> engine, RecordAccess records) {
                    NodeLabelReader.copyToSet(labelIds, labels);
                }
            }));
        } else {
            NodeLabelReader.copyToSet(nodeLabels.get(null), labels);
        }
        return labels;
    }

    private static void copyToSet(long[] array, Set<Long> set) {
        for (long labelId : array) {
            set.add(labelId);
        }
    }
}

