/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.HashMap;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.OwnerChain;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.RecordField;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;

class PropertyRecordCheck
implements RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> {
    PropertyRecordCheck() {
    }

    @Override
    public void checkChange(PropertyRecord oldRecord, PropertyRecord newRecord, CheckerEngine<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> engine, DiffRecordAccess records) {
        PropertyType type;
        this.check(newRecord, engine, (RecordAccess)records);
        if (oldRecord.inUse()) {
            for (PropertyField field : PropertyField.values()) {
                field.checkChange(oldRecord, newRecord, engine, records);
            }
        }
        if (oldRecord.inUse()) {
            OwnerChain.OLD.check(newRecord, engine, records);
        }
        if (newRecord.inUse()) {
            OwnerChain.NEW.check(newRecord, engine, records);
        }
        HashMap<Long, PropertyBlock> prevStrings = new HashMap<Long, PropertyBlock>();
        HashMap<Long, PropertyBlock> prevArrays = new HashMap<Long, PropertyBlock>();
        for (PropertyBlock block : oldRecord) {
            type = block.getType();
            if (type == null) continue;
            switch (type) {
                case STRING: {
                    prevStrings.put(block.getSingleValueLong(), block);
                    break;
                }
                case ARRAY: {
                    prevArrays.put(block.getSingleValueLong(), block);
                }
            }
        }
        for (PropertyBlock block : newRecord) {
            type = block.getType();
            if (type == null) continue;
            switch (type) {
                case STRING: {
                    prevStrings.remove(block.getSingleValueLong());
                    break;
                }
                case ARRAY: {
                    prevArrays.remove(block.getSingleValueLong());
                }
            }
        }
        for (PropertyBlock block : prevStrings.values()) {
            if (records.changedString(block.getSingleValueLong()) != null) continue;
            engine.report().stringUnreferencedButNotDeleted(block);
        }
        for (PropertyBlock block : prevArrays.values()) {
            if (records.changedArray(block.getSingleValueLong()) != null) continue;
            engine.report().arrayUnreferencedButNotDeleted(block);
        }
    }

    @Override
    public void check(PropertyRecord record, CheckerEngine<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> engine, RecordAccess records) {
        if (!record.inUse()) {
            return;
        }
        for (PropertyField field : PropertyField.values()) {
            field.checkConsistency(record, engine, records);
        }
        for (PropertyBlock block : record) {
            this.checkDataBlock(block, engine, records);
        }
    }

    private void checkDataBlock(PropertyBlock block, CheckerEngine<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> engine, RecordAccess records) {
        if (block.getKeyIndexId() < 0) {
            engine.report().invalidPropertyKey(block);
        } else {
            engine.comparativeCheck(records.propertyKey(block.getKeyIndexId()), PropertyRecordCheck.propertyKey(block));
        }
        PropertyType type = block.forceGetType();
        if (type == null) {
            engine.report().invalidPropertyType(block);
        } else {
            switch (type) {
                case STRING: {
                    engine.comparativeCheck(records.string(block.getSingleValueLong()), DynamicReference.string(block));
                    break;
                }
                case ARRAY: {
                    engine.comparativeCheck(records.array(block.getSingleValueLong()), DynamicReference.array(block));
                    break;
                }
                default: {
                    try {
                        type.getValue(block, null);
                        break;
                    }
                    catch (Exception e) {
                        engine.report().invalidPropertyValue(block);
                    }
                }
            }
        }
    }

    private static ComparativeRecordChecker<PropertyRecord, PropertyKeyTokenRecord, ConsistencyReport.PropertyConsistencyReport> propertyKey(final PropertyBlock block) {
        return new ComparativeRecordChecker<PropertyRecord, PropertyKeyTokenRecord, ConsistencyReport.PropertyConsistencyReport>(){

            @Override
            public void checkReference(PropertyRecord record, PropertyKeyTokenRecord referred, CheckerEngine<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> engine, RecordAccess records) {
                if (!referred.inUse()) {
                    engine.report().keyNotInUse(block, referred);
                }
            }

            public String toString() {
                return "PROPERTY_KEY";
            }
        };
    }

    private static abstract class DynamicReference
    implements ComparativeRecordChecker<PropertyRecord, DynamicRecord, ConsistencyReport.PropertyConsistencyReport> {
        final PropertyBlock block;

        private DynamicReference(PropertyBlock block) {
            this.block = block;
        }

        public static DynamicReference string(PropertyBlock block) {
            return new DynamicReference(block){

                @Override
                void notUsed(ConsistencyReport.PropertyConsistencyReport report, DynamicRecord value) {
                    report.stringNotInUse(this.block, value);
                }

                @Override
                void empty(ConsistencyReport.PropertyConsistencyReport report, DynamicRecord value) {
                    report.stringEmpty(this.block, value);
                }
            };
        }

        public static DynamicReference array(PropertyBlock block) {
            return new DynamicReference(block){

                @Override
                void notUsed(ConsistencyReport.PropertyConsistencyReport report, DynamicRecord value) {
                    report.arrayNotInUse(this.block, value);
                }

                @Override
                void empty(ConsistencyReport.PropertyConsistencyReport report, DynamicRecord value) {
                    report.arrayEmpty(this.block, value);
                }
            };
        }

        @Override
        public void checkReference(PropertyRecord record, DynamicRecord referred, CheckerEngine<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> engine, RecordAccess records) {
            if (!referred.inUse()) {
                this.notUsed(engine.report(), referred);
            } else if (referred.getLength() <= 0) {
                this.empty(engine.report(), referred);
            }
        }

        abstract void notUsed(ConsistencyReport.PropertyConsistencyReport var1, DynamicRecord var2);

        abstract void empty(ConsistencyReport.PropertyConsistencyReport var1, DynamicRecord var2);
    }

    private static enum PropertyField implements RecordField<PropertyRecord, ConsistencyReport.PropertyConsistencyReport>,
    ComparativeRecordChecker<PropertyRecord, PropertyRecord, ConsistencyReport.PropertyConsistencyReport>
    {
        PREV(Record.NO_PREVIOUS_PROPERTY){

            @Override
            public long valueFrom(PropertyRecord record) {
                return record.getPrevProp();
            }

            @Override
            long otherReference(PropertyRecord record) {
                return record.getNextProp();
            }

            @Override
            void notInUse(ConsistencyReport.PropertyConsistencyReport report, PropertyRecord property) {
                report.prevNotInUse(property);
            }

            @Override
            void noBackReference(ConsistencyReport.PropertyConsistencyReport report, PropertyRecord property) {
                report.previousDoesNotReferenceBack(property);
            }

            @Override
            void reportNotUpdated(ConsistencyReport.PropertyConsistencyReport report) {
                report.prevNotUpdated();
            }
        }
        ,
        NEXT(Record.NO_NEXT_PROPERTY){

            @Override
            public long valueFrom(PropertyRecord record) {
                return record.getNextProp();
            }

            @Override
            long otherReference(PropertyRecord record) {
                return record.getPrevProp();
            }

            @Override
            void notInUse(ConsistencyReport.PropertyConsistencyReport report, PropertyRecord property) {
                report.nextNotInUse(property);
            }

            @Override
            void noBackReference(ConsistencyReport.PropertyConsistencyReport report, PropertyRecord property) {
                report.nextDoesNotReferenceBack(property);
            }

            @Override
            void reportNotUpdated(ConsistencyReport.PropertyConsistencyReport report) {
                report.nextNotUpdated();
            }
        };

        private final Record NONE;

        private PropertyField(Record none) {
            this.NONE = none;
        }

        abstract long otherReference(PropertyRecord var1);

        @Override
        public void checkConsistency(PropertyRecord record, CheckerEngine<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> engine, RecordAccess records) {
            if (!this.NONE.is(this.valueFrom(record))) {
                engine.comparativeCheck(records.property(this.valueFrom(record)), this);
            }
        }

        @Override
        public void checkReference(PropertyRecord record, PropertyRecord referred, CheckerEngine<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> engine, RecordAccess records) {
            if (!referred.inUse()) {
                this.notInUse(engine.report(), referred);
            } else if (this.otherReference(referred) != record.getId()) {
                this.noBackReference(engine.report(), referred);
            }
        }

        @Override
        public void checkChange(PropertyRecord oldRecord, PropertyRecord newRecord, CheckerEngine<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> engine, DiffRecordAccess records) {
            if (!(newRecord.inUse() && this.valueFrom(oldRecord) == this.valueFrom(newRecord) || this.NONE.is(this.valueFrom(oldRecord)) || records.changedProperty(this.valueFrom(oldRecord)) != null)) {
                this.reportNotUpdated(engine.report());
            }
        }

        abstract void reportNotUpdated(ConsistencyReport.PropertyConsistencyReport var1);

        abstract void notInUse(ConsistencyReport.PropertyConsistencyReport var1, PropertyRecord var2);

        abstract void noBackReference(ConsistencyReport.PropertyConsistencyReport var1, PropertyRecord var2);
    }
}

