/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public abstract class RecordCheckWorker<RECORD>
implements Runnable {
    private volatile boolean done;
    protected final BlockingQueue<RECORD> recordsQ;

    public RecordCheckWorker(BlockingQueue<RECORD> recordsQ) {
        this.recordsQ = recordsQ;
    }

    public void done() {
        this.done = true;
    }

    @Override
    public void run() {
        while (!this.done || !this.recordsQ.isEmpty()) {
            try {
                RECORD record = this.recordsQ.poll(10L, TimeUnit.MILLISECONDS);
                if (record == null) continue;
                this.process(record);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                break;
            }
        }
    }

    protected abstract void process(RECORD var1);
}

