/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store;

import org.neo4j.consistency.store.DelegatingRecordAccess;
import org.neo4j.consistency.store.DirectRecordReference;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;

public class CacheSmallStoresRecordAccess
extends DelegatingRecordAccess {
    private final PropertyKeyTokenRecord[] propertyKeys;
    private final RelationshipTypeTokenRecord[] relationshipTypes;
    private final LabelTokenRecord[] labels;

    public CacheSmallStoresRecordAccess(RecordAccess delegate, PropertyKeyTokenRecord[] propertyKeys, RelationshipTypeTokenRecord[] relationshipTypes, LabelTokenRecord[] labels) {
        super(delegate);
        this.propertyKeys = propertyKeys;
        this.relationshipTypes = relationshipTypes;
        this.labels = labels;
    }

    @Override
    public RecordReference<RelationshipTypeTokenRecord> relationshipType(int id) {
        if (id < this.relationshipTypes.length) {
            return new DirectRecordReference<RelationshipTypeTokenRecord>(this.relationshipTypes[id], this);
        }
        return super.relationshipType(id);
    }

    @Override
    public RecordReference<PropertyKeyTokenRecord> propertyKey(int id) {
        if (id < this.propertyKeys.length) {
            return new DirectRecordReference<PropertyKeyTokenRecord>(this.propertyKeys[id], this);
        }
        return super.propertyKey(id);
    }

    @Override
    public RecordReference<LabelTokenRecord> label(int id) {
        if (id < this.labels.length) {
            return new DirectRecordReference<LabelTokenRecord>(this.labels[id], this);
        }
        return super.label(id);
    }
}

