/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.consistency.checking.full.RecordProcessor;

public class RecordCheckWorker<RECORD>
implements Runnable {
    private volatile boolean done;
    protected final BlockingQueue<RECORD> recordsQ;
    private final int id;
    private final AtomicInteger idQueue;
    private final RecordProcessor<RECORD> processor;

    public RecordCheckWorker(int id, AtomicInteger idQueue, BlockingQueue<RECORD> recordsQ, RecordProcessor<RECORD> processor) {
        this.id = id;
        this.idQueue = idQueue;
        this.recordsQ = recordsQ;
        this.processor = processor;
    }

    public void done() {
        this.done = true;
    }

    @Override
    public void run() {
        this.awaitMyTurnToInitialize();
        this.processor.init(this.id);
        this.tellNextThreadToInitialize();
        while (!this.done || !this.recordsQ.isEmpty()) {
            try {
                RECORD record = this.recordsQ.poll(10L, TimeUnit.MILLISECONDS);
                if (record == null) continue;
                this.processor.process(record);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                break;
            }
        }
    }

    private void awaitMyTurnToInitialize() {
        while (this.idQueue.get() < this.id - 1) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                break;
            }
        }
    }

    private void tellNextThreadToInitialize() {
        boolean set = this.idQueue.compareAndSet(this.id - 1, this.id);
        assert (set) : "Something wrong with the design here";
    }
}

