/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.internal;

import java.io.File;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.Service;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.extension.UnsatisfiedDependencyStrategies;
import org.neo4j.kernel.extension.dependency.AllByPrioritySelectionStrategy;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.spi.SimpleKernelContext;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.DependencySatisfier;
import org.neo4j.kernel.monitoring.Monitors;

public class SchemaIndexExtensionLoader {
    public static IndexProviderMap loadIndexProviders(KernelExtensions extensions) {
        AllByPrioritySelectionStrategy indexProviderSelection = new AllByPrioritySelectionStrategy();
        IndexProvider defaultIndexProvider = (IndexProvider)extensions.resolveDependency(IndexProvider.class, (DependencyResolver.SelectionStrategy)indexProviderSelection);
        return new DefaultIndexProviderMap(defaultIndexProvider, indexProviderSelection.lowerPrioritizedCandidates());
    }

    public static KernelExtensions instantiateKernelExtensions(File storeDir, FileSystemAbstraction fileSystem, Config config, LogService logService, PageCache pageCache, RecoveryCleanupWorkCollector recoveryCollector, DatabaseInfo databaseInfo, Monitors monitors) {
        Dependencies deps = new Dependencies();
        deps.satisfyDependencies(new Object[]{fileSystem, config, logService, pageCache, recoveryCollector, monitors});
        Iterable kernelExtensions = Service.load(KernelExtensionFactory.class);
        SimpleKernelContext kernelContext = new SimpleKernelContext(storeDir, databaseInfo, (DependencySatisfier)deps);
        return new KernelExtensions((KernelContext)kernelContext, kernelExtensions, deps, UnsatisfiedDependencyStrategies.ignore());
    }
}

