/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.pipes;

import org.neo4j.cypher.commands.PathPattern;
import org.neo4j.cypher.commands.Pattern;
import org.neo4j.cypher.commands.Predicate;
import org.neo4j.cypher.commands.RelatedTo;
import org.neo4j.cypher.internal.pipes.Pipe;
import org.neo4j.cypher.internal.pipes.matching.MatchingContext;
import org.neo4j.cypher.symbols.Identifier;
import org.neo4j.cypher.symbols.IterableType;
import org.neo4j.cypher.symbols.NodeType$;
import org.neo4j.cypher.symbols.PathType$;
import org.neo4j.cypher.symbols.RelationshipType$;
import org.neo4j.cypher.symbols.SymbolTable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u00015\u0011\u0011\"T1uG\"\u0004\u0016\u000e]3\u000b\u0005\r!\u0011!\u00029ja\u0016\u001c(BA\u0003\u0007\u0003!Ig\u000e^3s]\u0006d'BA\u0004\t\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011\u0011BC\u0001\u0006]\u0016|GG\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\f\u001b!\tyA#D\u0001\u0011\u0015\t\t\"#\u0001\u0003mC:<'\"A\n\u0002\t)\fg/Y\u0005\u0003+A\u0011aa\u00142kK\u000e$\bCA\f\u0019\u001b\u0005\u0011\u0011BA\r\u0003\u0005\u0011\u0001\u0016\u000e]3\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\tC\u0001\u0011\t\u0011)A\u0005-\u000511o\\;sG\u0016D\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\ta\u0006$H/\u001a:ogB\u0019Q%\f\u0019\u000f\u0005\u0019ZcBA\u0014+\u001b\u0005A#BA\u0015\r\u0003\u0019a$o\\8u}%\tQ$\u0003\u0002-9\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u00180\u0005\r\u0019V-\u001d\u0006\u0003Yq\u0001\"!\r\u001b\u000e\u0003IR!a\r\u0004\u0002\u0011\r|W.\\1oINL!!\u000e\u001a\u0003\u000fA\u000bG\u000f^3s]\"Aq\u0007\u0001B\u0001B\u0003%\u0001(\u0001\u0006qe\u0016$\u0017nY1uKN\u00042!J\u0017:!\t\t$(\u0003\u0002<e\tI\u0001K]3eS\u000e\fG/\u001a\u0005\u0006{\u0001!\tAP\u0001\u0007y%t\u0017\u000e\u001e \u0015\t}\u0002\u0015I\u0011\t\u0003/\u0001AQ!\t\u001fA\u0002YAQa\t\u001fA\u0002\u0011BQa\u000e\u001fA\u0002aBq\u0001\u0012\u0001C\u0002\u0013\u0005Q)A\bnCR\u001c\u0007.\u001b8h\u0007>tG/\u001a=u+\u00051\u0005CA$K\u001b\u0005A%BA%\u0003\u0003!i\u0017\r^2iS:<\u0017BA&I\u0005=i\u0015\r^2iS:<7i\u001c8uKb$\bBB'\u0001A\u0003%a)\u0001\tnCR\u001c\u0007.\u001b8h\u0007>tG/\u001a=uA!9q\n\u0001b\u0001\n\u0003\u0001\u0016aB:z[\n|Gn]\u000b\u0002#B\u0011!\u000bV\u0007\u0002'*\u0011qJB\u0005\u0003+N\u00131bU=nE>dG+\u00192mK\"1q\u000b\u0001Q\u0001\nE\u000b\u0001b]=nE>d7\u000f\t\u0005\u00063\u0002!\tAW\u0001\fS\u0012,g\u000e^5gS\u0016\u00148/F\u0001\\!\rav\fY\u0007\u0002;*\u0011a\fH\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u0018^!\t\u0011\u0016-\u0003\u0002c'\nQ\u0011\nZ3oi&4\u0017.\u001a:\t\u000b\u0011\u0004A\u0011A3\u0002\u001b\r\u0014X-\u0019;f%\u0016\u001cX\u000f\u001c;t+\t1\u0017\u0010\u0006\u0002hoB\u0019Q\u0005\u001b6\n\u0005%|#a\u0003+sCZ,'o]1cY\u0016\u0004Ba\u001b8ri:\u00111\u0004\\\u0005\u0003[r\ta\u0001\u0015:fI\u00164\u0017BA8q\u0005\ri\u0015\r\u001d\u0006\u0003[r\u0001\"a\u0004:\n\u0005M\u0004\"AB*ue&tw\r\u0005\u0002\u001ck&\u0011a\u000f\b\u0002\u0004\u0003:L\b\"\u0002=d\u0001\u0004Q\u0017A\u00029be\u0006l7\u000fB\u0003{G\n\u00071PA\u0001V#\taH\u000f\u0005\u0002\u001c{&\u0011a\u0010\b\u0002\b\u001d>$\b.\u001b8h\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007\tq#\u001b;fe\u0006\u0014G.Z(g%\u0016d\u0017\r^5p]ND\u0017\u000e]:\u0015\t\u0005\u0015\u00111\u0002\t\u00057\u0005\u001d\u0001-C\u0002\u0002\nq\u0011aa\u00149uS>t\u0007bBA\u0007\u007f\u0002\u0007\u0011qB\u0001\fSR,'/\u00192mKJ+G\u000e\u0005\u0003\u001c\u0003\u000f\t\bbBA\n\u0001\u0011\u0005\u0013QC\u0001\u000eKb,7-\u001e;j_:\u0004F.\u00198\u0015\u0003E\u0004")
public class MatchPipe
implements Pipe,
ScalaObject {
    private final Pipe source;
    private final Seq<Pattern> patterns;
    private final MatchingContext matchingContext;
    private final SymbolTable symbols;

    public MatchingContext matchingContext() {
        return this.matchingContext;
    }

    @Override
    public SymbolTable symbols() {
        return this.symbols;
    }

    public Seq<Identifier> identifiers() {
        return (Seq)this.patterns.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final MatchPipe $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<Identifier> apply(Pattern pattern) {
                Seq seq;
                Pattern pattern2 = pattern;
                if (pattern2 instanceof RelatedTo) {
                    RelatedTo relatedTo = (RelatedTo)pattern2;
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{new Identifier(relatedTo.left(), NodeType$.MODULE$.apply()), new Identifier(relatedTo.right(), NodeType$.MODULE$.apply()), new Identifier(relatedTo.relName(), RelationshipType$.MODULE$.apply())}));
                } else if (pattern2 instanceof PathPattern) {
                    PathPattern pathPattern;
                    PathPattern path2 = pathPattern = (PathPattern)pattern2;
                    seq = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{new Identifier(path2.start(), NodeType$.MODULE$.apply()), new Identifier(path2.end(), NodeType$.MODULE$.apply()), new Identifier(path2.pathName(), PathType$.MODULE$.apply())}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.$outer.org$neo4j$cypher$internal$pipes$MatchPipe$$iterableOfRelationships(path2.relIterator())), Seq$.MODULE$.canBuildFrom());
                } else {
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                }
                return seq;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public <U> Traversable<Map<String, Object>> createResults(Map<String, Object> params) {
        return (Traversable)this.source.createResults(params).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final MatchPipe $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Traversable<Map<String, Object>> apply(Map<String, Object> sourcePipeRow) {
                return this.$outer.matchingContext().getMatches(sourcePipeRow);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Traversable$.MODULE$.canBuildFrom());
    }

    public final Option<Identifier> org$neo4j$cypher$internal$pipes$MatchPipe$$iterableOfRelationships(Option<String> iterableRel) {
        Option<String> option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    option = iterableRel;
                    None$ none$2 = None$.MODULE$;
                    Option<String> option2 = option;
                    if (none$2 != null ? !none$2.equals(option2) : option2 != null) break block2;
                    none$ = None$.MODULE$;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                none$ = new Some((Object)new Identifier((String)((Some)option).x(), new IterableType(RelationshipType$.MODULE$.apply())));
            }
            return none$;
        }
        throw new MatchError(option);
    }

    @Override
    public String executionPlan() {
        return new StringBuilder().append((Object)this.source.executionPlan()).append((Object)"\r\nPatternMatch(").append((Object)this.patterns.mkString(",")).append((Object)")").toString();
    }

    public MatchPipe(Pipe source, Seq<Pattern> patterns, Seq<Predicate> predicates) {
        this.source = source;
        this.patterns = patterns;
        this.matchingContext = new MatchingContext(patterns, source.symbols(), predicates);
        this.symbols = source.symbols().add(this.identifiers());
    }
}

