/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public final class CompiledEquivalenceUtils {
    private CompiledEquivalenceUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean equals(Object lhs, Object rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null || lhs == Values.NO_VALUE || rhs == Values.NO_VALUE) {
            return false;
        }
        AnyValue lhsValue = lhs instanceof AnyValue ? (AnyValue)lhs : ValueUtils.of((Object)lhs);
        AnyValue rhsValue = rhs instanceof AnyValue ? (AnyValue)rhs : ValueUtils.of((Object)rhs);
        return lhsValue.equals((Object)rhsValue);
    }

    public static int hashCode(Object element) {
        if (element == null) {
            return 0;
        }
        if (element instanceof AnyValue) {
            return element.hashCode();
        }
        if (element instanceof Number) {
            return CompiledEquivalenceUtils.hashCode(((Number)element).longValue());
        }
        if (element instanceof Character) {
            return CompiledEquivalenceUtils.hashCode(((Character)element).charValue());
        }
        if (element instanceof Boolean) {
            return CompiledEquivalenceUtils.hashCode((Boolean)element);
        }
        if (element instanceof List) {
            return CompiledEquivalenceUtils.hashCode((List)element);
        }
        if (element instanceof Map) {
            return CompiledEquivalenceUtils.hashCode((Map)element);
        }
        if (element instanceof Object[]) {
            return CompiledEquivalenceUtils.hashCode((Object[])element);
        }
        if (element instanceof byte[]) {
            return CompiledEquivalenceUtils.hashCode((byte[])element);
        }
        if (element instanceof short[]) {
            return CompiledEquivalenceUtils.hashCode((short[])element);
        }
        if (element instanceof int[]) {
            return CompiledEquivalenceUtils.hashCode((int[])element);
        }
        if (element instanceof long[]) {
            return CompiledEquivalenceUtils.hashCode((long[])element);
        }
        if (element instanceof char[]) {
            return CompiledEquivalenceUtils.hashCode((char[])element);
        }
        if (element instanceof float[]) {
            return CompiledEquivalenceUtils.hashCode((float[])element);
        }
        if (element instanceof double[]) {
            return CompiledEquivalenceUtils.hashCode((double[])element);
        }
        if (element instanceof boolean[]) {
            return CompiledEquivalenceUtils.hashCode((boolean[])element);
        }
        return element.hashCode();
    }

    public static int hashCode(Map<String, Object> map) {
        int h = 0;
        for (Map.Entry<String, Object> next2 : map.entrySet()) {
            String k = next2.getKey();
            Object v = next2.getValue();
            h += (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : CompiledEquivalenceUtils.hashCode(v));
        }
        return h;
    }

    public static int hashCode(long value) {
        return Long.hashCode(value);
    }

    public static int hashCode(boolean value) {
        return Boolean.hashCode(value);
    }

    public static int hashCode(char value) {
        return Character.hashCode(value);
    }

    public static int hashCode(char[] array) {
        int len = array.length;
        switch (len) {
            case 0: {
                return 42;
            }
            case 1: {
                return CompiledEquivalenceUtils.hashCode(array[0]);
            }
            case 2: {
                return 31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1]);
            }
            case 3: {
                return (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1])) * 31 + CompiledEquivalenceUtils.hashCode(array[2]);
            }
        }
        return len * (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[len / 2]) * 31 + CompiledEquivalenceUtils.hashCode(array[len - 1]));
    }

    public static int hashCode(List<?> list) {
        int len = list.size();
        switch (len) {
            case 0: {
                return 42;
            }
            case 1: {
                return CompiledEquivalenceUtils.hashCode(list.get(0));
            }
            case 2: {
                return 31 * CompiledEquivalenceUtils.hashCode(list.get(0)) + CompiledEquivalenceUtils.hashCode(list.get(1));
            }
            case 3: {
                return (31 * CompiledEquivalenceUtils.hashCode(list.get(0)) + CompiledEquivalenceUtils.hashCode(list.get(1))) * 31 + CompiledEquivalenceUtils.hashCode(list.get(2));
            }
        }
        return len * (31 * CompiledEquivalenceUtils.hashCode(list.get(0)) + CompiledEquivalenceUtils.hashCode(list.get(len / 2)) * 31 + CompiledEquivalenceUtils.hashCode(list.get(len - 1)));
    }

    public static int hashCode(Object[] array) {
        int len = array.length;
        switch (len) {
            case 0: {
                return 42;
            }
            case 1: {
                return CompiledEquivalenceUtils.hashCode(array[0]);
            }
            case 2: {
                return 31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1]);
            }
            case 3: {
                return (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1])) * 31 + CompiledEquivalenceUtils.hashCode(array[2]);
            }
        }
        return len * (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[len / 2]) * 31 + CompiledEquivalenceUtils.hashCode(array[len - 1]));
    }

    public static int hashCode(byte[] array) {
        int len = array.length;
        switch (len) {
            case 0: {
                return 42;
            }
            case 1: {
                return CompiledEquivalenceUtils.hashCode(array[0]);
            }
            case 2: {
                return 31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1]);
            }
            case 3: {
                return (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1])) * 31 + CompiledEquivalenceUtils.hashCode(array[2]);
            }
        }
        return len * (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[len / 2]) * 31 + CompiledEquivalenceUtils.hashCode(array[len - 1]));
    }

    public static int hashCode(short[] array) {
        int len = array.length;
        switch (len) {
            case 0: {
                return 42;
            }
            case 1: {
                return CompiledEquivalenceUtils.hashCode(array[0]);
            }
            case 2: {
                return 31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1]);
            }
            case 3: {
                return (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1])) * 31 + CompiledEquivalenceUtils.hashCode(array[2]);
            }
        }
        return len * (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[len / 2]) * 31 + CompiledEquivalenceUtils.hashCode(array[len - 1]));
    }

    public static int hashCode(int[] array) {
        int len = array.length;
        switch (len) {
            case 0: {
                return 42;
            }
            case 1: {
                return CompiledEquivalenceUtils.hashCode(array[0]);
            }
            case 2: {
                return 31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1]);
            }
            case 3: {
                return (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1])) * 31 + CompiledEquivalenceUtils.hashCode(array[2]);
            }
        }
        return len * (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[len / 2]) * 31 + CompiledEquivalenceUtils.hashCode(array[len - 1]));
    }

    public static int hashCode(long[] array) {
        int len = array.length;
        switch (len) {
            case 0: {
                return 42;
            }
            case 1: {
                return CompiledEquivalenceUtils.hashCode(array[0]);
            }
            case 2: {
                return 31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1]);
            }
            case 3: {
                return (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1])) * 31 + CompiledEquivalenceUtils.hashCode(array[2]);
            }
        }
        return len * (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[len / 2]) * 31 + CompiledEquivalenceUtils.hashCode(array[len - 1]));
    }

    public static int hashCode(float[] array) {
        int len = array.length;
        switch (len) {
            case 0: {
                return 42;
            }
            case 1: {
                return CompiledEquivalenceUtils.hashCode((long)array[0]);
            }
            case 2: {
                return 31 * CompiledEquivalenceUtils.hashCode((long)array[0]) + CompiledEquivalenceUtils.hashCode((long)array[1]);
            }
            case 3: {
                return (31 * CompiledEquivalenceUtils.hashCode((long)array[0]) + CompiledEquivalenceUtils.hashCode((long)array[1])) * 31 + CompiledEquivalenceUtils.hashCode((long)array[2]);
            }
        }
        return len * (31 * CompiledEquivalenceUtils.hashCode((long)array[0]) + CompiledEquivalenceUtils.hashCode((long)array[len / 2]) * 31 + CompiledEquivalenceUtils.hashCode((long)array[len - 1]));
    }

    public static int hashCode(double[] array) {
        int len = array.length;
        switch (len) {
            case 0: {
                return 42;
            }
            case 1: {
                return CompiledEquivalenceUtils.hashCode((long)array[0]);
            }
            case 2: {
                return 31 * CompiledEquivalenceUtils.hashCode((long)array[0]) + CompiledEquivalenceUtils.hashCode((long)array[1]);
            }
            case 3: {
                return (31 * CompiledEquivalenceUtils.hashCode((long)array[0]) + CompiledEquivalenceUtils.hashCode((long)array[1])) * 31 + CompiledEquivalenceUtils.hashCode((long)array[2]);
            }
        }
        return len * (31 * CompiledEquivalenceUtils.hashCode((long)array[0]) + CompiledEquivalenceUtils.hashCode((long)array[len / 2]) * 31 + CompiledEquivalenceUtils.hashCode((long)array[len - 1]));
    }

    public static int hashCode(boolean[] array) {
        int len = array.length;
        switch (len) {
            case 0: {
                return 42;
            }
            case 1: {
                return CompiledEquivalenceUtils.hashCode(array[0]);
            }
            case 2: {
                return 31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1]);
            }
            case 3: {
                return (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[1])) * 31 + CompiledEquivalenceUtils.hashCode(array[2]);
            }
        }
        return len * (31 * CompiledEquivalenceUtils.hashCode(array[0]) + CompiledEquivalenceUtils.hashCode(array[len / 2]) * 31 + CompiledEquivalenceUtils.hashCode(array[len - 1]));
    }

    private static Boolean compareArrayAndList(Object array, List<?> list) {
        int length = Array.getLength(array);
        if (length != list.size()) {
            return false;
        }
        int i = 0;
        for (Object o : list) {
            if (CompiledEquivalenceUtils.equals(o, Array.get(array, i++))) continue;
            return false;
        }
        return true;
    }

    private static boolean mixedFloatEquality(Float a, Double b) {
        return a.doubleValue() == b.doubleValue();
    }
}

