/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen;

import java.util.ArrayList;
import java.util.HashMap;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.util.DefaultValueMapper;
import org.neo4j.kernel.impl.util.NodeProxyWrappingNodeValue;
import org.neo4j.kernel.impl.util.PathWrappingPathValue;
import org.neo4j.kernel.impl.util.RelationshipProxyWrappingValue;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public final class CompiledMaterializeValueMapper
implements ValueMapper<AnyValue> {
    private DefaultValueMapper defaultValueMapper;

    public CompiledMaterializeValueMapper(EmbeddedProxySPI proxySPI) {
        this.defaultValueMapper = new DefaultValueMapper(proxySPI);
    }

    public static AnyValue mapAnyValue(EmbeddedProxySPI proxySPI, AnyValue value) {
        CompiledMaterializeValueMapper mapper = new CompiledMaterializeValueMapper(proxySPI);
        return (AnyValue)value.map((ValueMapper)mapper);
    }

    public AnyValue mapNode(VirtualNodeValue value) {
        if (value instanceof NodeProxyWrappingNodeValue) {
            return value;
        }
        return ValueUtils.fromNodeProxy((Node)this.defaultValueMapper.mapNode(value));
    }

    public AnyValue mapRelationship(VirtualRelationshipValue value) {
        if (value instanceof RelationshipProxyWrappingValue) {
            return value;
        }
        return ValueUtils.fromRelationshipProxy((Relationship)this.defaultValueMapper.mapRelationship(value));
    }

    public AnyValue mapPath(PathValue value) {
        if (value instanceof PathWrappingPathValue) {
            return value;
        }
        return ValueUtils.fromPath((Path)this.defaultValueMapper.mapPath(value));
    }

    public AnyValue mapMap(MapValue value) {
        HashMap map = new HashMap();
        value.foreach((k, v) -> {
            AnyValue cfr_ignored_0 = (AnyValue)map.put(k, v.map((ValueMapper)this));
        });
        return VirtualValues.map(map);
    }

    public AnyValue mapSequence(SequenceValue value) {
        ArrayList list = new ArrayList(value.length());
        value.forEach(v -> list.add(v.map((ValueMapper)this)));
        return VirtualValues.fromList(list);
    }

    public AnyValue mapNoValue() {
        return Values.NO_VALUE;
    }

    public AnyValue mapText(TextValue value) {
        return value;
    }

    public AnyValue mapBoolean(BooleanValue value) {
        return value;
    }

    public AnyValue mapNumber(NumberValue value) {
        return value;
    }

    public AnyValue mapDateTime(DateTimeValue value) {
        return value;
    }

    public AnyValue mapLocalDateTime(LocalDateTimeValue value) {
        return value;
    }

    public AnyValue mapDate(DateValue value) {
        return value;
    }

    public AnyValue mapTime(TimeValue value) {
        return value;
    }

    public AnyValue mapLocalTime(LocalTimeValue value) {
        return value;
    }

    public AnyValue mapDuration(DurationValue value) {
        return value;
    }

    public AnyValue mapPoint(PointValue value) {
        return value;
    }
}

