/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import org.neo4j.cypher.internal.MapValueOps$;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.logging.Level;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.runtime.Nothing$;

public final class DriverSettingsEvaluator$ {
    public static DriverSettingsEvaluator$ MODULE$;

    static {
        new DriverSettingsEvaluator$();
    }

    public Map<String, AnyValue> org$neo4j$cypher$internal$DriverSettingsEvaluator$$convert(MapValue settings, String operation) {
        String ssl_enforced = "ssl_enforced";
        String connection_timeout = "connection_timeout";
        String connection_max_lifetime = "connection_max_lifetime";
        String connection_pool_acquisition_timeout = "connection_pool_acquisition_timeout";
        String connection_pool_idle_test = "connection_pool_idle_test";
        String connection_pool_max_size = "connection_pool_max_size";
        String logging_level = "logging_level";
        Set validKeys = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ssl_enforced, connection_timeout, connection_max_lifetime, connection_pool_acquisition_timeout, connection_pool_idle_test, connection_pool_max_size, logging_level}));
        Set invalidKeys = (Set)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(settings.keySet()).asScala()).toSet().diff((GenSet)validKeys);
        if (invalidKeys.nonEmpty()) {
            throw new InvalidArgumentsException(new StringBuilder(77).append("Failed to ").append(operation).append(": Invalid driver setting(s) provided: ").append(invalidKeys.mkString(", ")).append(". Valid driver settings are: ").append(validKeys.mkString(", ")).toString());
        }
        return ((TraversableOnce)new .colon.colon((Object)((Tuple2)MapValueOps$.MODULE$.Ops(settings).getOption(ssl_enforced).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AnyValue anyValue = x0$1;
            if (!(anyValue instanceof BooleanValue)) {
                throw DriverSettingsEvaluator$.throwExceptionWhenInvalidValue$1(ssl_enforced, "a boolean", operation);
            }
            BooleanValue booleanValue = (BooleanValue)anyValue;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ssl_enforced), (Object)booleanValue);
            return tuple2;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ssl_enforced), (Object)Values.NO_VALUE))), (List)new .colon.colon((Object)DriverSettingsEvaluator$.getDurationSetting$1(connection_timeout, false, settings, operation), (List)new .colon.colon((Object)DriverSettingsEvaluator$.getDurationSetting$1(connection_max_lifetime, DriverSettingsEvaluator$.getDurationSetting$default$2$1(), settings, operation), (List)new .colon.colon((Object)DriverSettingsEvaluator$.getDurationSetting$1(connection_pool_acquisition_timeout, DriverSettingsEvaluator$.getDurationSetting$default$2$1(), settings, operation), (List)new .colon.colon((Object)DriverSettingsEvaluator$.getDurationSetting$1(connection_pool_idle_test, DriverSettingsEvaluator$.getDurationSetting$default$2$1(), settings, operation), (List)new .colon.colon((Object)DriverSettingsEvaluator$.getConnectionPoolMaxSize$1(settings, connection_pool_max_size, operation), (List)new .colon.colon((Object)DriverSettingsEvaluator$.getLoggingLevel$1(settings, logging_level, operation), (List)Nil$.MODULE$)))))))).toMap(Predef$.MODULE$.$conforms());
    }

    private static final Nothing$ throwExceptionWhenInvalidValue$1(String key, String expectedType, String operation$2) {
        throw new InvalidArgumentsException(new StringBuilder(66).append("Failed to ").append(operation$2).append(": Invalid driver settings value for '").append(key).append("'. Expected ").append(expectedType).append(" value.").toString());
    }

    private static final Tuple2 getDurationSetting$1(String key, boolean allowNegative, MapValue settings$1, String operation$2) {
        return (Tuple2)MapValueOps$.MODULE$.Ops(settings$1).getOption(key).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DurationValue durationValue;
            AnyValue anyValue = x0$1;
            if (anyValue instanceof DurationValue) {
                durationValue = (DurationValue)anyValue;
                if (!allowNegative && durationValue.compareTo(DurationValue.ZERO) < 0) {
                    throw new InvalidArgumentsException(new StringBuilder(83).append("Failed to ").append(operation$2).append(": Invalid driver settings value for '").append(key).append("'. Negative duration is not allowed.").toString());
                }
            } else {
                throw DriverSettingsEvaluator$.throwExceptionWhenInvalidValue$1(key, "a duration", operation$2);
            }
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)durationValue);
            return tuple2;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)Values.NO_VALUE));
    }

    private static final boolean getDurationSetting$default$2$1() {
        return true;
    }

    private static final /* synthetic */ TextValue liftedTree1$1(StringValue x2$1, String operation$2, String logging_level$1) {
        TextValue textValue;
        try {
            Level.valueOf((String)x2$1.stringValue().toUpperCase());
            textValue = x2$1.toUpper();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidArgumentsException(new StringBuilder(67).append("Failed to ").append(operation$2).append(": Invalid driver settings value for '").append(logging_level$1).append("'. Expected one of ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Level.values())).mkString(", ")).append(".").toString());
        }
        return textValue;
    }

    private static final Tuple2 getLoggingLevel$1(MapValue settings$1, String logging_level$1, String operation$2) {
        return (Tuple2)MapValueOps$.MODULE$.Ops(settings$1).getOption(logging_level$1).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AnyValue anyValue = x0$1;
            if (!(anyValue instanceof StringValue)) {
                throw DriverSettingsEvaluator$.throwExceptionWhenInvalidValue$1(logging_level$1, "a string", operation$2);
            }
            StringValue stringValue = (StringValue)anyValue;
            Tuple2 tuple2 = new Tuple2((Object)logging_level$1, (Object)DriverSettingsEvaluator$.liftedTree1$1(stringValue, operation$2, logging_level$1));
            return tuple2;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logging_level$1), (Object)Values.NO_VALUE));
    }

    private static final Tuple2 getConnectionPoolMaxSize$1(MapValue settings$1, String connection_pool_max_size$1, String operation$2) {
        return (Tuple2)MapValueOps$.MODULE$.Ops(settings$1).getOption(connection_pool_max_size$1).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl = false;
            IntegralValue integralValue = null;
            AnyValue anyValue = x0$1;
            if (anyValue instanceof IntegralValue) {
                bl = true;
                integralValue = (IntegralValue)anyValue;
                if (integralValue.equals(0L)) {
                    throw new InvalidArgumentsException(new StringBuilder(70).append("Failed to ").append(operation$2).append(": Invalid driver settings value for '").append(connection_pool_max_size$1).append("'. Zero is not allowed.").toString());
                }
            }
            if (!bl) {
                throw DriverSettingsEvaluator$.throwExceptionWhenInvalidValue$1(connection_pool_max_size$1, "an integer", operation$2);
            }
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)connection_pool_max_size$1), (Object)integralValue);
            return tuple2;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)connection_pool_max_size$1), (Object)Values.NO_VALUE));
    }

    private DriverSettingsEvaluator$() {
        MODULE$ = this;
    }
}

