/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.ancestor;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipExpander;

public class AncestorsUtil {
    public static Node lowestCommonAncestor(List<Node> nodeSet, RelationshipExpander expander) {
        Node lowerCommonAncestor = null;
        if (nodeSet.size() > 1) {
            Node firstNode = nodeSet.get(0);
            LinkedList<Node> firstAncestors = AncestorsUtil.getAncestorsPlusSelf(firstNode, expander);
            for (int i = 1; i < nodeSet.size() && !firstAncestors.isEmpty(); ++i) {
                Node currentNode = nodeSet.get(i);
                AncestorsUtil.lookForCommonAncestor(firstAncestors, currentNode, expander);
            }
            if (!firstAncestors.isEmpty()) {
                lowerCommonAncestor = firstAncestors.get(0);
            }
        }
        return lowerCommonAncestor;
    }

    private static LinkedList<Node> getAncestorsPlusSelf(Node node, RelationshipExpander expander) {
        LinkedList<Node> ancestors = new LinkedList<Node>();
        ancestors.add(node);
        Iterator relIterator = expander.expand(node).iterator();
        while (relIterator.hasNext()) {
            Relationship rel = (Relationship)relIterator.next();
            node = rel.getOtherNode(node);
            ancestors.add(node);
            relIterator = expander.expand(node).iterator();
        }
        return ancestors;
    }

    private static void lookForCommonAncestor(LinkedList<Node> commonAncestors, Node currentNode, RelationshipExpander expander) {
        while (currentNode != null) {
            for (int i = 0; i < commonAncestors.size(); ++i) {
                Node node = commonAncestors.get(i);
                if (node.getId() != currentNode.getId()) continue;
                for (int j = 0; j < i; ++j) {
                    commonAncestors.pollFirst();
                }
                return;
            }
            Iterator relIt = expander.expand(currentNode).iterator();
            if (relIt.hasNext()) {
                Relationship rel = (Relationship)relIt.next();
                currentNode = rel.getOtherNode(currentNode);
                continue;
            }
            currentNode = null;
        }
    }
}

