/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.LockImpl;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockType;

public class TopLevelTransaction
implements org.neo4j.graphdb.Transaction {
    private final AbstractTransactionManager transactionManager;
    private final TransactionOutcome transactionOutcome = new TransactionOutcome();
    private final LockManager lockManager;
    private final LockReleaser lockReleaser;

    public TopLevelTransaction(AbstractTransactionManager transactionManager, LockManager lockManager, LockReleaser lockReleaser) {
        this.transactionManager = transactionManager;
        this.lockManager = lockManager;
        this.lockReleaser = lockReleaser;
    }

    @Override
    public void failure() {
        this.transactionOutcome.failed();
        try {
            this.transactionManager.getTransaction().setRollbackOnly();
        }
        catch (Exception e) {
            throw new TransactionFailureException("Failed to mark transaction as rollback only.", e);
        }
    }

    @Override
    public void success() {
        this.transactionOutcome.success();
    }

    protected boolean isMarkedAsSuccessful() {
        try {
            return this.transactionOutcome.canCommit() && this.transactionManager.getTransaction().getStatus() != 1;
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void finish() {
        try {
            Transaction transaction = this.transactionManager.getTransaction();
            if (transaction != null) {
                if (this.transactionOutcome.canCommit()) {
                    transaction.commit();
                } else {
                    transaction.rollback();
                }
            }
        }
        catch (RollbackException e) {
            throw new TransactionFailureException("Unable to commit transaction", e);
        }
        catch (Exception e) {
            if (this.transactionOutcome.triedToSucceed()) {
                throw new TransactionFailureException("Unable to commit transaction", e);
            }
            throw new TransactionFailureException("Unable to rollback transaction", e);
        }
    }

    @Override
    public Lock acquireWriteLock(PropertyContainer entity) {
        this.lockManager.getWriteLock(entity);
        LockReleaser.LockElement lockElement = this.lockReleaser.addLockToTransaction(entity, LockType.WRITE);
        return new LockImpl(this.lockManager, lockElement);
    }

    @Override
    public Lock acquireReadLock(PropertyContainer entity) {
        this.lockManager.getReadLock(entity);
        LockReleaser.LockElement lockElement = this.lockReleaser.addLockToTransaction(entity, LockType.READ);
        return new LockImpl(this.lockManager, lockElement);
    }

    static class TransactionOutcome {
        private boolean success = false;
        private boolean failure = false;

        TransactionOutcome() {
        }

        public void failed() {
            this.failure = true;
        }

        public void success() {
            this.success = true;
        }

        public boolean canCommit() {
            return this.success && !this.failure;
        }

        public boolean triedToSucceed() {
            return this.success;
        }
    }
}

