/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.info;

import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.JvmMetadataRepository;

public class JvmChecker {
    public static final String INCOMPATIBLE_JVM_WARNING = "WARNING! You are using an unsupported Java runtime. Please use Oracle(R) Java(TM) Runtime Environment 6.";
    public static final String INCOMPATIBLE_JVM_VERSION_WARNING = "WARNING! You are using an unsupported version of the Java runtime. Please use Oracle(R) Java(TM) Runtime Environment 6.";
    private final StringLogger stringLogger;
    private final JvmMetadataRepository jvmMetadataRepository;

    public JvmChecker(StringLogger stringLogger, JvmMetadataRepository jvmMetadataRepository) {
        this.stringLogger = stringLogger;
        this.jvmMetadataRepository = jvmMetadataRepository;
    }

    public void checkJvmCompatibilityAndIssueWarning() {
        String javaVmName = this.jvmMetadataRepository.getJavaVmName();
        String javaVersion = this.jvmMetadataRepository.getJavaVersion();
        if (!javaVmName.matches("Java HotSpot\\(TM\\) (64-Bit Server|Client) VM")) {
            this.stringLogger.warn(INCOMPATIBLE_JVM_WARNING);
        } else if (!javaVersion.matches("^1\\.6.*")) {
            this.stringLogger.warn(INCOMPATIBLE_JVM_VERSION_WARNING);
        }
    }
}

