/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.cache.SizeOfs;

final class FloatProperty
extends DefinedProperty {
    private final float value;

    FloatProperty(int propertyKeyId, float value) {
        super(propertyKeyId);
        this.value = value;
    }

    @Override
    public boolean valueEquals(Object other) {
        if (other instanceof Float) {
            return this.value == ((Float)other).floatValue();
        }
        return this.valueCompare(Float.valueOf(this.value), other);
    }

    @Override
    boolean hasEqualValue(DefinedProperty that) {
        return this.value == ((FloatProperty)that).value;
    }

    @Override
    public Number value() {
        return Float.valueOf(this.value);
    }

    @Override
    int valueHash() {
        return Float.floatToIntBits(this.value);
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return SizeOfs.withObjectOverhead(8);
    }
}

