/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.impl.util.DependencySatisfier;
import org.neo4j.kernel.impl.util.UnsatisfiedDependencyException;

public class MigrationDependencyResolver
extends DependencyResolver.Adapter
implements DependencySatisfier {
    private final Map<Class, Object> dependencies = new HashMap<Class, Object>();
    private static final Function<Class, Class[]> SUPER_CLASS = new Function<Class, Class[]>(){

        @Override
        public Class[] apply(Class from) {
            Class superClass = from.getSuperclass();
            if (superClass == null) {
                return NO_CLASSES;
            }
            return new Class[]{superClass};
        }
    };
    private static final Function<Class, Class[]> INTERFACES = new Function<Class, Class[]>(){

        @Override
        public Class[] apply(Class from) {
            return from.getInterfaces();
        }
    };
    private static final Class[] NO_CLASSES = new Class[0];

    @Override
    public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) throws UnsatisfiedDependencyException {
        Object dependency = this.dependencies.get(type);
        if (dependency == null) {
            dependency = this.getDependencyForType(type, SUPER_CLASS);
        }
        if (dependency == null) {
            dependency = this.getDependencyForType(type, INTERFACES);
        }
        if (dependency == null) {
            throw new UnsatisfiedDependencyException(new Exception("Weird exception nesting here, but anyways, I couldn't find any dependency for " + type));
        }
        return type.cast(dependency);
    }

    @Override
    public <T> void satisfyDependency(Class<T> type, T dependency) {
        this.dependencies.put(type, dependency);
    }

    private Object getDependencyForType(Class type, Function<Class, Class[]> traverser) {
        int i$ = 0;
        Class[] arr$ = traverser.apply(type);
        int len$ = arr$.length;
        if (i$ < len$) {
            Class candidate = arr$[i$];
            Object dependency = this.dependencies.get(candidate);
            if (dependency != null) {
                return dependency;
            }
            return this.getDependencyForType(candidate, traverser);
        }
        return null;
    }
}

