/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;

public abstract class PollingExecutionMonitor
implements ExecutionMonitor {
    private final long interval;

    public PollingExecutionMonitor(long interval) {
        this.interval = interval;
    }

    @Override
    public void monitor(StageExecution execution) {
        long startTime = System.currentTimeMillis();
        this.start(execution);
        while (execution.stillExecuting()) {
            this.poll(execution);
            this.finishAwareSleep(execution);
        }
        this.end(execution, System.currentTimeMillis() - startTime);
    }

    protected void end(StageExecution execution, long totalTimeMillis) {
    }

    protected void start(StageExecution execution) {
    }

    protected abstract void poll(StageExecution var1);

    private void finishAwareSleep(StageExecution execution) {
        long endTime = System.currentTimeMillis() + this.interval;
        while (System.currentTimeMillis() < endTime && execution.stillExecuting()) {
            try {
                Thread.sleep(Math.min(10L, Math.max(0L, endTime - System.currentTimeMillis())));
            }
            catch (InterruptedException e) {
                execution.panic(e);
                break;
            }
        }
    }
}

