/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.Description;
import org.neo4j.helpers.Functions;
import org.neo4j.kernel.configuration.Internal;
import org.neo4j.kernel.configuration.Obsoleted;
import org.neo4j.kernel.impl.transaction.IllegalResourceException;

public class SettingsResourceBundle
extends ResourceBundle {
    public static final String MANDATORY = ".mandatory";
    public static final String DEFAULT = ".default";
    public static final String INTERNAL = ".internal";
    public static final String VALIDATIONMESSAGE = ".validationmessage";
    public static final String OBSOLETED = ".obsoleted";
    public static final String DEPRECATED = ".deprecated";
    public static final String DESCRIPTION = ".description";
    public static final String CLASS_DESCRIPTION = "description";
    private final Class<?> settingsClass;

    public SettingsResourceBundle(Class settingsClass) {
        this.settingsClass = settingsClass;
    }

    @Override
    protected Object handleGetObject(String key) {
        if (key.equals(CLASS_DESCRIPTION)) {
            Description description = this.settingsClass.getAnnotation(Description.class);
            return description.value();
        }
        String name = key.substring(0, key.lastIndexOf("."));
        if (key.endsWith(DESCRIPTION)) {
            Field settingField = this.getField(name);
            return settingField.getAnnotation(Description.class).value();
        }
        if (key.endsWith(DEPRECATED)) {
            return "The " + name + " configuration setting has been deprecated.";
        }
        if (key.endsWith(INTERNAL)) {
            return "The " + name + " configuration setting is for internal use.";
        }
        if (key.endsWith(OBSOLETED)) {
            Field settingField = this.getField(name);
            return settingField.getAnnotation(Obsoleted.class).value();
        }
        if (key.endsWith(VALIDATIONMESSAGE)) {
            try {
                Field settingField = this.getField(name);
                Setting setting = (Setting)settingField.get(null);
                return setting.toString();
            }
            catch (Exception settingField) {
                // empty catch block
            }
        }
        if (key.endsWith(DEFAULT)) {
            Field settingField = this.getField(name);
            try {
                Setting setting = (Setting)settingField.get(null);
                return setting.getDefaultValue().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (key.endsWith(MANDATORY)) {
            return "The " + name + " configuration setting is mandatory.";
        }
        throw new IllegalResourceException("Could not find resource for property " + key);
    }

    private Setting<?> getFieldValue(String name) throws IllegalAccessException {
        return (Setting)this.getField(name).get(null);
    }

    private Field getField(String name) {
        for (Field field : this.settingsClass.getFields()) {
            if (!Setting.class.isAssignableFrom(field.getType())) continue;
            try {
                Setting setting = (Setting)field.get(null);
                if (!setting.name().equals(name)) continue;
                return field;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IllegalResourceException("Could not find resource for property with prefix " + name);
    }

    @Override
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.keySet());
    }

    @Override
    public Set<String> keySet() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        Description description = this.settingsClass.getAnnotation(Description.class);
        if (description != null) {
            keys.add(CLASS_DESCRIPTION);
        }
        for (Field field : this.settingsClass.getFields()) {
            Setting setting = null;
            try {
                setting = (Setting)field.get(null);
            }
            catch (Exception e) {
                continue;
            }
            String name = setting.name();
            if (field.getAnnotation(Internal.class) != null) {
                keys.add(name + INTERNAL);
            }
            if (field.getAnnotation(Description.class) != null) {
                Object defaultValue;
                block11: {
                    keys.add(name + DESCRIPTION);
                    keys.add(name + VALIDATIONMESSAGE);
                    defaultValue = null;
                    try {
                        defaultValue = setting.apply(Functions.nullFunction());
                    }
                    catch (IllegalArgumentException iae) {
                        if (iae.toString().indexOf("mandatory") == -1) break block11;
                        keys.add(name + MANDATORY);
                    }
                }
                if (defaultValue != null) {
                    keys.add(name + DEFAULT);
                }
            } else {
                System.out.println("Missing description for: " + field.getName());
            }
            if (field.getAnnotation(Deprecated.class) != null) {
                keys.add(name + DEPRECATED);
            }
            if (field.getAnnotation(Obsoleted.class) == null) continue;
            keys.add(name + OBSOLETED);
        }
        return keys;
    }
}

