/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.state.LabelChangeSummary;
import org.neo4j.kernel.impl.transaction.state.PropertyRecordChange;

public class PropertyPhysicalToLogicalConverter {
    private final PropertyStore propertyStore;

    public PropertyPhysicalToLogicalConverter(PropertyStore propertyStore) {
        this.propertyStore = propertyStore;
    }

    public void apply(Collection<NodePropertyUpdate> target, Iterable<PropertyRecordChange> changes, long[] labelsBefore, long[] labelsAfter) {
        HashMap<Integer, PropertyBlock> beforeMap = new HashMap<Integer, PropertyBlock>();
        HashMap<Integer, PropertyBlock> afterMap = new HashMap<Integer, PropertyBlock>();
        long nodeId = this.mapBlocks(changes, beforeMap, afterMap);
        Iterator i$ = this.union(beforeMap.keySet(), afterMap.keySet()).iterator();
        while (i$.hasNext()) {
            int key = (Integer)i$.next();
            PropertyBlock beforeBlock = (PropertyBlock)beforeMap.get(key);
            PropertyBlock afterBlock = (PropertyBlock)afterMap.get(key);
            NodePropertyUpdate update = null;
            if (beforeBlock != null && afterBlock != null) {
                if (!beforeBlock.hasSameContentsAs(afterBlock)) {
                    Object beforeVal = this.valueOf(beforeBlock);
                    Object afterVal = this.valueOf(afterBlock);
                    update = NodePropertyUpdate.change(nodeId, key, beforeVal, labelsBefore, afterVal, labelsAfter);
                }
            } else if (afterBlock != null) {
                LabelChangeSummary summary = new LabelChangeSummary(labelsBefore, labelsAfter);
                if (summary.hasUnchangedLabels()) {
                    update = NodePropertyUpdate.add(nodeId, key, this.valueOf(afterBlock), summary.getUnchangedLabels());
                }
            } else if (beforeBlock != null) {
                update = NodePropertyUpdate.remove(nodeId, key, this.valueOf(beforeBlock), labelsBefore);
            } else {
                throw new IllegalStateException("Weird, an update with no property value for before or after");
            }
            if (update == null) continue;
            target.add(update);
        }
    }

    private <T> Set<T> union(Set<T> first, Set<T> other) {
        HashSet<T> union = new HashSet<T>(first);
        union.addAll(other);
        return union;
    }

    private long mapBlocks(Iterable<PropertyRecordChange> changes, Map<Integer, PropertyBlock> beforeMap, Map<Integer, PropertyBlock> afterMap) {
        long nodeId = -1L;
        for (PropertyRecordChange change : changes) {
            nodeId = this.equalCheck(change.getBefore().getNodeId(), nodeId);
            nodeId = this.equalCheck(change.getAfter().getNodeId(), nodeId);
            this.mapBlocks(change.getBefore(), beforeMap);
            this.mapBlocks(change.getAfter(), afterMap);
        }
        return nodeId;
    }

    private long equalCheck(long nodeId, long expectedNodeId) {
        assert (expectedNodeId == -1L || nodeId == expectedNodeId) : "Node id differs expected " + expectedNodeId + ", but was " + nodeId;
        return nodeId;
    }

    private void mapBlocks(PropertyRecord record, Map<Integer, PropertyBlock> blocks) {
        for (PropertyBlock block : record) {
            blocks.put(block.getKeyIndexId(), block);
        }
    }

    private Object valueOf(PropertyBlock block) {
        if (block == null) {
            return null;
        }
        return block.getType().getValue(block, this.propertyStore);
    }
}

