/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.helpers.Clock;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerMonitor;
import org.neo4j.kernel.impl.transaction.tracing.CheckPointTracer;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceWaitEvent;

public class DefaultCheckPointerTracer
implements CheckPointTracer,
CheckPointerMonitor {
    private final Clock clock;
    private final AtomicLong counter = new AtomicLong();
    private final AtomicLong accumulatedTotalTimeNanos = new AtomicLong();
    private volatile long startTimeNanos;
    private LogCheckPointEvent logCheckPointEvent = new LogCheckPointEvent(){

        @Override
        public void close() {
            DefaultCheckPointerTracer.this.accumulatedTotalTimeNanos.addAndGet(DefaultCheckPointerTracer.this.clock.nanoTime() - DefaultCheckPointerTracer.this.startTimeNanos);
        }

        @Override
        public LogForceWaitEvent beginLogForceWait() {
            return LogForceWaitEvent.NULL;
        }

        @Override
        public LogForceEvent beginLogForce() {
            return LogForceEvent.NULL;
        }
    };

    public DefaultCheckPointerTracer() {
        this(Clock.SYSTEM_CLOCK);
    }

    DefaultCheckPointerTracer(Clock clock) {
        this.clock = clock;
    }

    @Override
    public LogCheckPointEvent beginCheckPoint() {
        this.startTimeNanos = this.clock.nanoTime();
        this.counter.incrementAndGet();
        return this.logCheckPointEvent;
    }

    @Override
    public long numberOfCheckPointEvents() {
        return this.counter.get();
    }

    @Override
    public long checkPointAccumulatedTotalTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.accumulatedTotalTimeNanos.get());
    }
}

