/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;

public class ByteBufferWritableByteChannel
implements WritableByteChannel {
    private boolean closed = false;
    private ByteBuffer buffer;

    public ByteBufferWritableByteChannel() {
        this(1024);
    }

    public ByteBufferWritableByteChannel(int initialSize) {
        this.buffer = ByteBuffer.allocate(initialSize);
    }

    public void reset() {
        this.buffer.clear();
        this.closed = false;
    }

    public ByteBuffer getBuffer() {
        this.buffer.flip();
        return this.buffer;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        int remaining = src.remaining();
        try {
            this.buffer.put(src);
        }
        catch (BufferOverflowException e) {
            ByteBuffer newBuffer = ByteBuffer.allocate(this.buffer.capacity() + src.remaining());
            newBuffer.put(this.buffer);
            return this.write(src);
        }
        return remaining;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

