/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;

public class CoarseBoundedProgressExecutionMonitor
extends ExecutionMonitor.Adapter {
    private long totalDoneBatches;
    private final long highNodeId;
    private final long highRelationshipId;
    private int previousPercent;

    public CoarseBoundedProgressExecutionMonitor(long highNodeId, long highRelationshipId) {
        super(1L, TimeUnit.SECONDS);
        this.highNodeId = highNodeId;
        this.highRelationshipId = highRelationshipId;
    }

    @Override
    public void check(StageExecution[] executions) {
        this.updatePercent(executions);
    }

    private void updatePercent(StageExecution[] executions) {
        int highestPercentThere = this.previousPercent;
        for (StageExecution execution : executions) {
            long maxNumberOfBatches = this.highNodeId / (long)execution.getConfig().batchSize() * 2L + this.highRelationshipId / (long)execution.getConfig().batchSize() * 3L;
            long doneBatches = this.totalDoneBatches + this.doneBatches(execution);
            int percentThere = (int)((double)doneBatches * 100.0 / (double)maxNumberOfBatches);
            percentThere = Math.min(percentThere, 100);
            highestPercentThere = Math.max(percentThere, highestPercentThere);
        }
        this.applyPercentage(highestPercentThere);
    }

    private void applyPercentage(int percentThere) {
        while (this.previousPercent < percentThere) {
            this.percent(++this.previousPercent);
        }
    }

    protected void percent(int percent) {
        System.out.print(".");
        if (percent % 10 == 0) {
            System.out.println("  " + percent + "%");
        }
    }

    private long doneBatches(StageExecution execution) {
        return IteratorUtil.last(execution.steps()).stats().stat(Keys.done_batches).asLong();
    }

    @Override
    public void end(StageExecution[] executions, long totalTimeMillis) {
        for (StageExecution execution : executions) {
            this.totalDoneBatches += this.doneBatches(execution);
        }
    }

    @Override
    public void done(long totalTimeMillis, String additionalInformation) {
        this.applyPercentage(100);
    }
}

